ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments } = event;

    const alienSuggestionProvider = (context, builder) => {
        for (let i = 1; i <= 300; i++) {
            let alienData = global[`alienevo_alien_${i}`];
            if (alienData && alienData[0]) {
                builder.suggest(`${alienData[0]}`);
            }
        }
        return builder.buildFuture();
    };

    event.register(
        Commands.literal("poweradd")
        .requires(src => src.hasPermission(2))
        .then(Commands.argument('entity', Arguments.PLAYER.create(event))
            .then(Commands.argument('alien', Arguments.RESOURCE_LOCATION.create(event))
                .suggests(alienSuggestionProvider)
                .executes(ctx => {
                    let target = Arguments.PLAYER.getResult(ctx, 'entity');
                    let alienResource = Arguments.RESOURCE_LOCATION.getResult(ctx, 'alien');
                    let alienName = alienResource.toString();

                    let alienNumber = -1;
                    for (let i = 1; i <= 300; i++) {
                        let alienData = global[`alienevo_alien_${i}`];
                        if (alienData && alienData[0] && alienData[0].toLowerCase() === alienName.toLowerCase()) {
                            alienNumber = i;
                            break;
                        }
                    }
                    if (alienNumber === -1) {
                        ctx.source.sendFailure(Text.of(`Unknown alien: ${alienName}`));
                        return 0;
                    }

                    let chosenPlaylist = -1;
                    let chosenSlot = -1;

                    outer:
                    for (let playlist = 1; playlist <= 10; playlist++) {
                        for (let slot = 1; slot <= 10; slot++) {
                            if (target.persistentData.getInt(`alienevo.alien_${playlist}_${slot}`) === 0) {
                                chosenPlaylist = playlist;
                                chosenSlot = slot;
                                break outer;
                            }
                        }
                    }

                    if (chosenPlaylist === -1 || chosenSlot === -1) {
                        ctx.source.sendFailure(Text.of("All playlists are full."));
                        return 0;
                    }

                    target.persistentData.putInt(`alienevo.alien_${chosenPlaylist}_${chosenSlot}`, alienNumber);

                    ctx.source.sendSuccess(Text.of(`Added alien §b${alienName} §7to playlist §f${chosenPlaylist} §7slot §f${chosenSlot} for §f${target.getName().getString()}`), true);

                    return 1;
                })
            )
        )
    );
});

// Thanks to KubeJS scripts for Entity(ionutz16o0) //