// kubejs/server_scripts/debate_toggle.js

ServerEvents.commandRegistry(event => {
  const { commands: Commands } = event;

  event.register(
    Commands.literal('debate')
      .requires(source => source.hasPermission(2)) // OP only
      .then(
        Commands.literal('disable')
          .executes(ctx => {
            const player = ctx.getSource().getPlayerOrException();
            const server = ctx.source.server;

            // Create objective if missing
            server.runCommandSilent('scoreboard objectives add debatecount dummy');

            // Set THIS player's score to 1
            server.runCommandSilent(`scoreboard players set ${player.getName().getString()} debatecount 1`);

            ctx.source.sendSuccess({ text: `§cDebate system disabled for ${player.getName().getString()} (debatecount = 1)` }, true);
            return 1;
          })
      )
      .then(
        Commands.literal('enable')
          .executes(ctx => {
            const player = ctx.getSource().getPlayerOrException();
            const server = ctx.source.server;

            // Create objective if missing
            server.runCommandSilent('scoreboard objectives add debatecount dummy');

            // Set THIS player's score to 0
            server.runCommandSilent(`scoreboard players set ${player.getName().getString()} debatecount 0`);

            ctx.source.sendSuccess({ text: `§aDebate system enabled for ${player.getName().getString()} (debatecount = 0)` }, true);
            return 1;
          })
      )
  );
});
