ServerEvents.commandRegistry(event => {
  const { commands: Commands, arguments: Arguments } = event;

  event.register(
    Commands.literal('debate_dimension')
	  .requires(source => source.hasPermission(2)) // <-- only ops
      .then(
        Commands.literal('in')
          .executes(ctx => {
            const player = ctx.getSource().getPlayerOrException();
            if (player.level.dimension.toString() === "mypowers:debate") return 0;
            teleportAndSpawn(player, ctx);
            return 1;
          })
          .then(
            Commands.argument('target', Arguments.PLAYER.create(event))
              .executes(ctx => {
                const target = Arguments.PLAYER.getResult(ctx, 'target');
                if (target.level.dimension.toString() === "mypowers:debate") return 0;
                teleportAndSpawn(target, ctx);
                return 1;
              })
          )
      )
      .then(
        Commands.literal('out')
          .executes(ctx => {
            const player = ctx.getSource().getPlayerOrException();
            teleportBack(player, ctx);
            return 1;
          })
          .then(
            Commands.argument('target', Arguments.PLAYER.create(event))
              .executes(ctx => {
                const target = Arguments.PLAYER.getResult(ctx, 'target');
                teleportBack(target, ctx);
                return 1;
              })
          )
      )
  );

  function teleportAndSpawn(entity, ctx) {
    const server = entity.server;

    // Save original location
    const oldDim = entity.level.dimension.toString();
    const oldX = Math.floor(entity.getX());
    const oldY = Math.floor(entity.getY());
    const oldZ = Math.floor(entity.getZ());

    const data = entity.persistentData;
    data.putString("return_dimension", oldDim);
    data.putInt("return_x", oldX);
    data.putInt("return_y", oldY);
    data.putInt("return_z", oldZ);

    // New location in debate dimension
    const newDim = "mypowers:debate";
    const randomX = Math.floor(Math.random() * 2001) - 1000;
    const randomZ = Math.floor(Math.random() * 2001) - 1000;
    const newY = 121;

    const username = entity.getName().getString();

    const tpCmd = `execute as ${username} at @s in ${newDim} run tp @s ${randomX} ${newY} ${randomZ}`;
    server.runCommandSilent(tpCmd);

    // Summon the cube
    const placeCmd = `execute in ${newDim} run place template mypowers:debatecube/cube ${randomX - 10} ${newY - 2} ${randomZ - 27}`;
    server.runCommandSilent(placeCmd);
  }

  function teleportBack(entity, ctx) {
    if (entity.level.dimension.toString() !== "mypowers:debate") return;

    const server = entity.server;
    const data = entity.persistentData;

    if (
      !data.contains("return_dimension") ||
      !data.contains("return_x") ||
      !data.contains("return_y") ||
      !data.contains("return_z")
    ) return;

    const returnDim = data.getString("return_dimension");
    const x = data.getInt("return_x");
    const y = data.getInt("return_y");
    const z = data.getInt("return_z");

    const username = entity.getName().getString();

    // Clear area and remove blocks/armor stands
    server.runCommandSilent(`execute as ${username} at @s run fill ~-15 ~-15 ~-15 ~15 ~15 ~15 air replace minecraft:barrier`);
    server.runCommandSilent(`execute as ${username} at @s run kill @e[type=armor_stand,distance=..30]`);

    // Teleport back
    const tpCmd = `execute as ${username} at @s in ${returnDim} run tp @s ${x} ${y} ${z}`;
    server.runCommandSilent(tpCmd);

    // Clear persistent data
    data.remove("return_dimension");
    data.remove("return_x");
    data.remove("return_y");
    data.remove("return_z");

    // Remove Dummysapien

    server.runCommandSilent(`kill @e[type=armor_stand,tag=dummysapien,distance=..5,limit=10]`);
  }
});

// Thanks to KubeJS scripts for Entity(ionutz16o0) //