// kubejs/server_scripts/nullvoid_paths.js
BlockEvents.rightClicked(event => {
  const { block, item, player, level } = event

  // Only care about shovels
  if (!item.id.endsWith('_shovel')) return

  // Case 1: Dirt → Nullvoid Path (only inside nullvoid dimension)
  if (
    level.dimension === 'mypowers:nullvoid' &&
    (block.id === 'minecraft:dirt' || block.id === 'minecraft:grass_block' || block.id === 'minecraft:coarse_dirt')
  ) {
    block.set('kubejs:nullvoid_soil_path')
    player.swing()
    event.cancel()
    return
  }

  // Case 2: Nullvoid Soil → Nullvoid Path (any dimension)
  if (block.id === 'kubejs:nullvoid_soil') {
    block.set('kubejs:nullvoid_soil_path')
    player.swing()
    event.cancel()
    return
  }
})
