// kubejs/server_scripts/nullvoid_portal.js

ServerEvents.commandRegistry(event => {
  const { commands: Commands, arguments: Arguments } = event;

  event.register(
    Commands.literal('nullvoid_portal')
	  .requires(source => source.hasPermission(2)) // <-- only ops
      // ===== IN =====
      .then(
        Commands.literal('in')
          .executes(ctx => {
            const player = ctx.getSource().getPlayerOrException();
            teleportAndSpawn(player);
            return 1;
          })
          .then(
            Commands.argument('target', Arguments.PLAYER.create(event))
              .executes(ctx => {
                const target = Arguments.PLAYER.getResult(ctx, 'target');
                teleportAndSpawn(target);
                return 1;
              })
          )
      )
      // ===== OUT =====
      .then(
        Commands.literal('out')
          .executes(ctx => {
            const player = ctx.getSource().getPlayerOrException();
            teleportBack(player);
            return 1;
          })
          .then(
            Commands.argument('target', Arguments.PLAYER.create(event))
              .executes(ctx => {
                const target = Arguments.PLAYER.getResult(ctx, 'target');
                teleportBack(target);
                return 1;
              })
          )
      )
  );

  // ===== Helpers =====

  function teleportRandomSafe(entity, dimension) {
    const server = entity.server;
    const level = server.getLevel(dimension);

    if (!level) {
      const username = entity.getName().getString();
      server.runCommandSilent(`execute as ${username} in ${dimension} run tp @s 0 120 0`);
      return;
    }

    const WORLD_RADIUS = 1000;
    const MAX_TRIES = 50;
    let x = 0, y = 0, z = 0;

    for (let tries = 0; tries < MAX_TRIES; tries++) {
      const rx = Math.floor(Math.random() * (WORLD_RADIUS * 2)) - WORLD_RADIUS;
      const rz = Math.floor(Math.random() * (WORLD_RADIUS * 2)) - WORLD_RADIUS;

      // Scan from top down to find first solid block
      for (let ry = 255; ry > 0; ry--) {
        const blockBelow = level.getBlock(rx, ry - 1, rz);
        const blockFeet  = level.getBlock(rx, ry, rz);
        const blockHead  = level.getBlock(rx, ry + 1, rz);

        if (isSolid(blockBelow) && isAirLike(blockFeet) && isAirLike(blockHead)) {
          x = rx + 0.5;
          y = ry;
          z = rz + 0.5;
          // Found safe spot
          const username = entity.getName().getString();
          server.runCommandSilent(`execute as ${username} in ${dimension} run tp @s ${x} ${y} ${z}`);
          return;
        }
      }
    }

    // fallback if no safe spot found
    const username = entity.getName().getString();
    server.runCommandSilent(`execute as ${username} in ${dimension} run tp @s 0 120 0`);
  }

  function teleportAndSpawn(entity) {
    teleportRandomSafe(entity, "mypowers:nullvoid");
  }

  function teleportBack(entity) {
    teleportRandomSafe(entity, entity.level.dimension.toString());
  }

  function isAirLike(block) {
    const id = String(block.id);
    return id === "minecraft:air" || id === "minecraft:cave_air" || id === "minecraft:void_air";
  }

  function isHazard(block) {
    const id = String(block.id);
    return id === "minecraft:water" || id === "minecraft:flowing_water" ||
           id === "minecraft:lava"  || id === "minecraft:flowing_lava";
  }

  function isSolid(block) {
    const id = String(block.id);
    return !isAirLike(block) && !isHazard(block);
  }
});
