/*
 * Decompiled with CFR 0.152.
 */
package org.djtmk.beeauction;

import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.djtmk.beeauction.auctions.AuctionManager;
import org.djtmk.beeauction.commands.GlobalAuctionCommand;
import org.djtmk.beeauction.commands.GlobalAuctionTabCompleter;
import org.djtmk.beeauction.commands.PodbijCommand;
import org.djtmk.beeauction.config.ConfigManager;
import org.djtmk.beeauction.data.DatabaseManager;
import org.djtmk.beeauction.economy.EconomyHandler;

public final class BeeAuction
extends JavaPlugin {
    private static BeeAuction instance;
    private static final Logger log;
    private ConfigManager configManager;
    private DatabaseManager databaseManager;
    private AuctionManager auctionManager;
    private EconomyHandler economyHandler;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfigs();
        if (!this.setupEconomy()) {
            log.severe(String.format("[%s] - Disabled due to no Vault dependency found!", this.getDescription().getName()));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.databaseManager = new DatabaseManager(this);
        this.databaseManager.initialize();
        this.auctionManager = new AuctionManager(this);
        String adminCommandName = this.configManager.getAdminCommandName();
        String playerBidCommand = this.configManager.getPlayerBidCommand();
        if (this.getCommand(adminCommandName) != null) {
            this.getCommand(adminCommandName).setExecutor((CommandExecutor)new GlobalAuctionCommand(this));
            this.getCommand(adminCommandName).setTabCompleter((TabCompleter)new GlobalAuctionTabCompleter(this));
        } else {
            log.warning("Failed to register admin command: " + adminCommandName + ". Using default command.");
            this.getCommand("globalauction").setExecutor((CommandExecutor)new GlobalAuctionCommand(this));
            this.getCommand("globalauction").setTabCompleter((TabCompleter)new GlobalAuctionTabCompleter(this));
        }
        if (this.getCommand(playerBidCommand) != null) {
            this.getCommand(playerBidCommand).setExecutor((CommandExecutor)new PodbijCommand(this));
        } else {
            log.warning("Failed to register player bid command: " + playerBidCommand + ". Using default command.");
            this.getCommand("podbij").setExecutor((CommandExecutor)new PodbijCommand(this));
        }
        log.info(String.format("[%s] - Enabled version %s", this.getDescription().getName(), this.getDescription().getVersion()));
    }

    public void onDisable() {
        if (this.auctionManager != null) {
            this.auctionManager.cancelAuction();
        }
        if (this.databaseManager != null) {
            this.databaseManager.shutdown();
        }
        log.info(String.format("[%s] - Disabled version %s", this.getDescription().getName(), this.getDescription().getVersion()));
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economyHandler = new EconomyHandler((Economy)rsp.getProvider());
        return true;
    }

    public static BeeAuction getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public AuctionManager getAuctionManager() {
        return this.auctionManager;
    }

    public EconomyHandler getEconomyHandler() {
        return this.economyHandler;
    }

    static {
        log = Logger.getLogger("Minecraft");
    }
}

