/*
 * Decompiled with CFR 0.152.
 */
package org.djtmk.beeauction.auctions;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.djtmk.beeauction.BeeAuction;
import org.djtmk.beeauction.config.AuctionEnum;
import org.djtmk.beeauction.config.MessageEnum;
import org.djtmk.beeauction.util.ItemUtils;
import org.djtmk.beeauction.util.MessageUtil;

public class Auction {
    private final BeeAuction plugin;
    private final AuctionEnum.AuctionType type;
    private final ItemStack item;
    private final String command;
    private final double startPrice;
    private final int duration;
    private final String customName;
    private final String ownerName;
    private double currentBid;
    private Player highestBidder;
    private boolean active;
    private long endTime;

    public Auction(BeeAuction plugin, ItemStack item, double startPrice, int duration, String customName, String ownerName) {
        this.plugin = plugin;
        this.type = AuctionEnum.AuctionType.ITEM;
        this.item = item;
        this.command = null;
        this.startPrice = startPrice;
        this.duration = duration;
        this.customName = customName;
        this.ownerName = ownerName;
        this.currentBid = startPrice;
        this.highestBidder = null;
        this.active = false;
    }

    public Auction(BeeAuction plugin, ItemStack item, double startPrice, int duration, String customName) {
        this(plugin, item, startPrice, duration, customName, "Unknown");
    }

    public Auction(BeeAuction plugin, ItemStack item, double startPrice, int duration) {
        this(plugin, item, startPrice, duration, null, "Unknown");
    }

    public Auction(BeeAuction plugin, String command, double startPrice, int duration, String customName, String ownerName) {
        this.plugin = plugin;
        this.type = AuctionEnum.AuctionType.COMMAND;
        this.item = null;
        this.command = command;
        this.startPrice = startPrice;
        this.duration = duration;
        this.customName = customName;
        this.ownerName = ownerName;
        this.currentBid = startPrice;
        this.highestBidder = null;
        this.active = false;
    }

    public Auction(BeeAuction plugin, String command, double startPrice, int duration, String customName) {
        this(plugin, command, startPrice, duration, customName, "Unknown");
    }

    public Auction(BeeAuction plugin, String command, double startPrice, int duration) {
        this(plugin, command, startPrice, duration, null, "Unknown");
    }

    public void start() {
        this.active = true;
        this.endTime = System.currentTimeMillis() + (long)this.duration * 1000L;
        String rewardName = this.getRewardName();
        Bukkit.broadcastMessage((String)MessageEnum.AUCTION_STARTED.get("item", rewardName, "price", this.plugin.getEconomyHandler().format(this.startPrice)));
    }

    public void end() {
        this.active = false;
        if (this.highestBidder == null) {
            if (this.type == AuctionEnum.AuctionType.ITEM && this.item != null && this.ownerName != null) {
                Player owner = Bukkit.getPlayerExact((String)this.ownerName);
                if (owner != null && owner.isOnline()) {
                    owner.getInventory().addItem(new ItemStack[]{this.item.clone()});
                    MessageUtil.sendMessage(owner, "\u00a7aYour auctioned item has been returned to you as there were no bids.");
                } else {
                    this.plugin.getLogger().warning("Could not return item to offline owner: " + this.ownerName);
                }
            }
            Bukkit.broadcastMessage((String)MessageEnum.CANCELLED.get());
            return;
        }
        if (this.highestBidder.isOnline()) {
            if (this.type == AuctionEnum.AuctionType.ITEM && this.item != null) {
                this.highestBidder.getInventory().addItem(new ItemStack[]{this.item.clone()});
                MessageUtil.sendMessage(this.highestBidder, MessageEnum.WIN.get("item", ItemUtils.getItemDisplayName(this.item)));
                this.plugin.getDatabaseManager().saveAuctionResult(this.highestBidder.getName(), this.currentBid, this.type.name(), ItemUtils.getItemDisplayName(this.item));
            } else if (this.type == AuctionEnum.AuctionType.COMMAND && this.command != null) {
                String formattedCommand = this.command.replace("%player%", this.highestBidder.getName());
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)formattedCommand);
                String rewardName = this.getRewardName().replace("%player%", this.highestBidder.getName());
                MessageUtil.sendMessage(this.highestBidder, MessageEnum.WIN.get("item", rewardName));
                this.plugin.getDatabaseManager().saveAuctionResult(this.highestBidder.getName(), this.currentBid, this.type.name(), rewardName);
            }
        }
        String rewardName = this.getRewardName().replace("%player%", this.highestBidder.getName());
        Bukkit.broadcastMessage((String)MessageEnum.AUCTION_ENDED.get("player", this.highestBidder.getName(), "amount", this.plugin.getEconomyHandler().format(this.currentBid), "item", rewardName));
    }

    public void cancel() {
        this.active = false;
        if (this.highestBidder != null && this.highestBidder.isOnline()) {
            this.plugin.getEconomyHandler().deposit(this.highestBidder, this.currentBid);
            MessageUtil.sendMessage(this.highestBidder, MessageEnum.CANCELLED.get());
        }
        if (this.type == AuctionEnum.AuctionType.ITEM && this.item != null && this.ownerName != null) {
            Player owner = Bukkit.getPlayerExact((String)this.ownerName);
            if (owner != null && owner.isOnline()) {
                owner.getInventory().addItem(new ItemStack[]{this.item.clone()});
                MessageUtil.sendMessage(owner, "\u00a7aYour auctioned item has been returned to you.");
            } else {
                this.plugin.getLogger().warning("Could not return item to offline owner: " + this.ownerName);
            }
        }
        Bukkit.broadcastMessage((String)MessageEnum.CANCELLED.get());
    }

    public boolean placeBid(Player player, double amount) {
        if (!this.active) {
            MessageUtil.sendMessage(player, MessageEnum.NO_AUCTION.get());
            return false;
        }
        double minBidAmount = this.plugin.getConfigManager().getConfig().getDouble("auction.min-bid-amount", 100.0);
        if (amount < minBidAmount) {
            MessageUtil.sendMessage(player, MessageEnum.INVALID_AMOUNT.get("amount", this.plugin.getEconomyHandler().format(minBidAmount)));
            return false;
        }
        if (amount <= this.currentBid) {
            MessageUtil.sendMessage(player, MessageEnum.INVALID_AMOUNT.get("amount", this.plugin.getEconomyHandler().format(this.currentBid + 1.0)));
            return false;
        }
        if (!this.plugin.getEconomyHandler().hasEnough(player, amount)) {
            MessageUtil.sendMessage(player, MessageEnum.NOT_ENOUGH_MONEY.get());
            return false;
        }
        if (this.highestBidder != null && this.highestBidder.isOnline()) {
            this.plugin.getEconomyHandler().deposit(this.highestBidder, this.currentBid);
            MessageUtil.sendMessage(this.highestBidder, MessageEnum.OUTBID.get("player", player.getName()));
        }
        this.plugin.getEconomyHandler().withdraw(player, amount);
        this.currentBid = amount;
        this.highestBidder = player;
        int timeExtension = this.plugin.getConfigManager().getConfig().getInt("auction.bid-time-extension", 30);
        int timeThreshold = this.plugin.getConfigManager().getConfig().getInt("auction.bid-time-threshold", 60);
        int remainingTime = this.getTimeRemaining();
        boolean timeExtended = false;
        if (remainingTime < timeThreshold) {
            this.endTime += (long)timeExtension * 1000L;
            timeExtended = true;
        }
        String timeExtensionText = timeExtended ? MessageEnum.TIME_EXTENSION.get("seconds", String.valueOf(timeExtension)) : "";
        Bukkit.broadcastMessage((String)MessageEnum.NEW_BID.get("player", player.getName(), "amount", this.plugin.getEconomyHandler().format(amount), "time_extension", timeExtensionText));
        return true;
    }

    public String getRewardName() {
        if (this.customName != null && !this.customName.isEmpty()) {
            return MessageUtil.colorize(this.customName);
        }
        if (this.type == AuctionEnum.AuctionType.ITEM && this.item != null) {
            return ItemUtils.getItemDisplayName(this.item);
        }
        if (this.type == AuctionEnum.AuctionType.COMMAND && this.command != null) {
            String[] parts;
            if (this.command.contains("&")) {
                int lastSpaceBeforeColor = -1;
                for (int i = 0; i < this.command.length(); ++i) {
                    if (this.command.charAt(i) != ' ' || i + 1 >= this.command.length() || this.command.charAt(i + 1) != '&') continue;
                    lastSpaceBeforeColor = i;
                }
                if (lastSpaceBeforeColor != -1) {
                    String extractedName = this.command.substring(lastSpaceBeforeColor + 1);
                    return MessageUtil.colorize(extractedName);
                }
            }
            if ((parts = this.command.split(" ")).length >= 3) {
                String amount;
                Object itemName;
                block11: {
                    itemName = "";
                    amount = "";
                    try {
                        int lastPartAsInt = Integer.parseInt(parts[parts.length - 1]);
                        amount = parts[parts.length - 1];
                        itemName = parts[parts.length - 2];
                    }
                    catch (NumberFormatException e) {
                        itemName = parts[parts.length - 1];
                        if (parts.length < 4) break block11;
                        try {
                            int secondToLastPartAsInt = Integer.parseInt(parts[parts.length - 2]);
                            amount = parts[parts.length - 2];
                            itemName = parts[parts.length - 3];
                        }
                        catch (NumberFormatException ex) {
                            if (parts.length < 3) break block11;
                            itemName = parts[parts.length - 2] + " " + (String)itemName;
                        }
                    }
                }
                itemName = ItemUtils.formatMaterialName((String)itemName);
                Object result = !amount.isEmpty() ? amount + " " + (String)itemName : itemName;
                return MessageUtil.colorize((String)result);
            }
            return MessageUtil.colorize(this.command);
        }
        return "Unknown";
    }

    public int getTimeRemaining() {
        if (!this.active) {
            return 0;
        }
        long remaining = this.endTime - System.currentTimeMillis();
        return Math.max(0, (int)(remaining / 1000L));
    }

    public boolean isActive() {
        return this.active;
    }

    public AuctionEnum.AuctionType getType() {
        return this.type;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public String getCommand() {
        return this.command;
    }

    public double getStartPrice() {
        return this.startPrice;
    }

    public double getCurrentBid() {
        return this.currentBid;
    }

    public Player getHighestBidder() {
        return this.highestBidder;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getOwnerName() {
        return this.ownerName;
    }
}

