/*
 * Decompiled with CFR 0.152.
 */
package org.djtmk.beeauction.auctions;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.djtmk.beeauction.BeeAuction;
import org.djtmk.beeauction.auctions.Auction;
import org.djtmk.beeauction.auctions.AuctionTask;
import org.djtmk.beeauction.config.AuctionEnum;
import org.djtmk.beeauction.config.MessageEnum;
import org.djtmk.beeauction.util.ItemUtils;
import org.djtmk.beeauction.util.MessageUtil;

public class AuctionManager {
    private final BeeAuction plugin;
    private Auction activeAuction;
    private AuctionTask auctionTask;
    private BukkitTask scheduledTask;
    private Map<String, Boolean> startedAuctions = new HashMap<String, Boolean>();
    private DayOfWeek lastCheckedDay;

    public AuctionManager(BeeAuction plugin) {
        this.plugin = plugin;
        this.lastCheckedDay = LocalDateTime.now().getDayOfWeek();
        if (plugin.getConfigManager().isScheduleEnabled()) {
            this.scheduleAutoAuctions();
        }
    }

    public boolean startItemAuction(ItemStack item, int duration, double startPrice, String customName, String ownerName) {
        if (this.activeAuction != null && this.activeAuction.isActive()) {
            return false;
        }
        this.activeAuction = new Auction(this.plugin, item, startPrice, duration, customName, ownerName);
        this.activeAuction.start();
        this.auctionTask = new AuctionTask(this.plugin, this.activeAuction, this);
        this.auctionTask.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        return true;
    }

    public boolean startItemAuction(ItemStack item, int duration, double startPrice, String customName) {
        return this.startItemAuction(item, duration, startPrice, customName, "Unknown");
    }

    public boolean startItemAuction(ItemStack item, int duration, double startPrice) {
        return this.startItemAuction(item, duration, startPrice, null, "Unknown");
    }

    public boolean startCommandAuction(String command, int duration, double startPrice, String customName, String ownerName) {
        if (this.activeAuction != null && this.activeAuction.isActive()) {
            return false;
        }
        this.activeAuction = new Auction(this.plugin, command, startPrice, duration, customName, ownerName);
        this.activeAuction.start();
        this.auctionTask = new AuctionTask(this.plugin, this.activeAuction, this);
        this.auctionTask.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        return true;
    }

    public boolean startCommandAuction(String command, int duration, double startPrice, String customName) {
        return this.startCommandAuction(command, duration, startPrice, customName, "Unknown");
    }

    public boolean startCommandAuction(String command, int duration, double startPrice) {
        return this.startCommandAuction(command, duration, startPrice, null, "Unknown");
    }

    public boolean cancelAuction() {
        if (this.activeAuction == null || !this.activeAuction.isActive()) {
            return false;
        }
        this.activeAuction.cancel();
        if (this.auctionTask != null) {
            this.auctionTask.cancelTask();
            this.auctionTask = null;
        }
        this.activeAuction = null;
        return true;
    }

    public boolean placeBid(Player player, double amount) {
        if (this.activeAuction == null || !this.activeAuction.isActive()) {
            MessageUtil.sendMessage(player, MessageEnum.NO_AUCTION.get());
            return false;
        }
        return this.activeAuction.placeBid(player, amount);
    }

    public void clearActiveAuction() {
        this.activeAuction = null;
        this.auctionTask = null;
    }

    public boolean hasActiveAuction() {
        return this.activeAuction != null && this.activeAuction.isActive();
    }

    public Auction getActiveAuction() {
        return this.activeAuction;
    }

    public void scheduleAutoAuctions() {
        this.plugin.getLogger().info("Scheduling auto auctions...");
        if (!this.plugin.getConfigManager().isScheduleEnabled()) {
            this.plugin.getLogger().info("Scheduled auctions are disabled in config.yml");
            if (this.scheduledTask != null) {
                this.scheduledTask.cancel();
                this.scheduledTask = null;
                this.plugin.getLogger().info("Cancelled existing scheduled auction task");
            }
            return;
        }
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.plugin.getLogger().info("Cancelled existing scheduled auction task");
        }
        this.startedAuctions.clear();
        this.lastCheckedDay = LocalDateTime.now().getDayOfWeek();
        this.scheduledTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::checkScheduledAuctions, 200L, 200L);
        Bukkit.getScheduler().runTask((Plugin)this.plugin, this::checkScheduledAuctions);
    }

    private void checkScheduledAuctions() {
        FileConfiguration config;
        ConfigurationSection scheduleSection;
        LocalDateTime now = LocalDateTime.now();
        DayOfWeek currentDay = now.getDayOfWeek();
        LocalTime currentTime = now.toLocalTime();
        if (this.lastCheckedDay != currentDay) {
            this.startedAuctions.clear();
            this.lastCheckedDay = currentDay;
        }
        if ((scheduleSection = (config = this.plugin.getConfigManager().getConfig()).getConfigurationSection("schedule")) == null) {
            this.plugin.getLogger().warning("No 'schedule' section found in config.yml");
            return;
        }
        List auctionsList = scheduleSection.getMapList("auctions");
        if (auctionsList == null || auctionsList.isEmpty()) {
            this.plugin.getLogger().warning("No auctions found in schedule.auctions list");
            return;
        }
        for (Map auctionMap : auctionsList) {
            try {
                AuctionEnum.AuctionType type;
                int timeDifference;
                LocalTime scheduledTime;
                String timeString;
                String dayString;
                block32: {
                    dayString = (String)auctionMap.get("day");
                    if (dayString == null) {
                        this.plugin.getLogger().warning("Scheduled auction missing 'day' field");
                        continue;
                    }
                    try {
                        AuctionEnum.Day day = AuctionEnum.Day.valueOf(dayString);
                        DayOfWeek scheduledDay = DayOfWeek.valueOf(day.name());
                        if (scheduledDay != currentDay) {
                        }
                        break block32;
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().warning("Invalid day in scheduled auction: " + dayString);
                    }
                    continue;
                }
                Object timeValue = auctionMap.get("time");
                if (timeValue == null) {
                    this.plugin.getLogger().warning("Scheduled auction missing 'time' field");
                    continue;
                }
                if (timeValue instanceof Integer) {
                    int timeInt = (Integer)timeValue;
                    int hours = timeInt / 100;
                    int minutes = timeInt % 100;
                    timeString = String.format("%02d:%02d", hours, minutes);
                } else if (timeValue instanceof String) {
                    timeString = (String)timeValue;
                } else {
                    this.plugin.getLogger().warning("Unexpected time format in scheduled auction: " + String.valueOf(timeValue) + " (type: " + timeValue.getClass().getName() + ")");
                    timeString = String.valueOf(timeValue);
                }
                try {
                    scheduledTime = LocalTime.parse(timeString, DateTimeFormatter.ofPattern("HH:mm"));
                }
                catch (DateTimeParseException e) {
                    this.plugin.getLogger().warning("Invalid time format in scheduled auction: " + timeString + ". Expected format: HH:mm (e.g. 08:25)");
                    continue;
                }
                String auctionKey = dayString + "_" + timeString;
                if (this.startedAuctions.containsKey(auctionKey) && this.startedAuctions.get(auctionKey).booleanValue() || (timeDifference = currentTime.toSecondOfDay() - scheduledTime.toSecondOfDay()) < -5 || timeDifference > 30) continue;
                Map rewardMap = (Map)auctionMap.get("reward");
                if (rewardMap == null) {
                    this.plugin.getLogger().warning("Scheduled auction missing 'reward' field");
                    continue;
                }
                String rewardType = (String)rewardMap.get("type");
                if (rewardType == null) {
                    this.plugin.getLogger().warning("Scheduled auction missing 'reward.type' field");
                    continue;
                }
                try {
                    type = AuctionEnum.AuctionType.valueOf(rewardType);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid reward type in scheduled auction: " + rewardType);
                    continue;
                }
                double startPrice = rewardMap.get("start_price") instanceof Number ? ((Number)rewardMap.get("start_price")).doubleValue() : 100.0;
                String auctionName = (String)auctionMap.get("name");
                if (auctionName == null || auctionName.isEmpty()) {
                    auctionName = "Scheduled Auction";
                }
                if (type == AuctionEnum.AuctionType.ITEM) {
                    Map itemMap = (Map)rewardMap.get("item");
                    if (itemMap == null) {
                        this.plugin.getLogger().warning("Scheduled item auction missing 'reward.item' field");
                        continue;
                    }
                    ConfigurationSection itemSection = config.createSection("temp_item");
                    for (Map.Entry entry : itemMap.entrySet()) {
                        if (!(entry.getKey() instanceof String)) continue;
                        itemSection.set((String)entry.getKey(), entry.getValue());
                    }
                    ItemStack item = ItemUtils.deserializeItem(itemSection);
                    config.set("temp_item", null);
                    if (item != null) {
                        boolean success = this.startItemAuction(item, 300, startPrice, auctionName);
                        if (!success) {
                            this.plugin.getLogger().warning("Failed to start item auction");
                        }
                    } else {
                        this.plugin.getLogger().warning("Failed to create item for auction");
                    }
                } else if (type == AuctionEnum.AuctionType.COMMAND) {
                    String command = (String)rewardMap.get("command");
                    if (command == null || command.isEmpty()) {
                        this.plugin.getLogger().warning("Scheduled command auction missing or empty 'reward.command' field");
                        continue;
                    }
                    boolean success = this.startCommandAuction(command, 300, startPrice, auctionName);
                    if (!success) {
                        this.plugin.getLogger().warning("Failed to start command auction");
                    }
                }
                this.startedAuctions.put(auctionKey, true);
                break;
            }
            catch (IllegalArgumentException | DateTimeParseException e) {
                this.plugin.getLogger().log(Level.WARNING, "Invalid scheduled auction configuration", e);
            }
        }
    }
}

