/*
 * Decompiled with CFR 0.152.
 */
package org.djtmk.beeauction.auctions;

import org.bukkit.boss.BarColor;
import org.bukkit.scheduler.BukkitRunnable;
import org.djtmk.beeauction.BeeAuction;
import org.djtmk.beeauction.auctions.Auction;
import org.djtmk.beeauction.auctions.AuctionManager;
import org.djtmk.beeauction.util.BossBarUtil;

public class AuctionTask
extends BukkitRunnable {
    private final BeeAuction plugin;
    private final Auction auction;
    private final AuctionManager auctionManager;

    public AuctionTask(BeeAuction plugin, Auction auction, AuctionManager auctionManager) {
        this.plugin = plugin;
        this.auction = auction;
        this.auctionManager = auctionManager;
        BossBarUtil.createAuctionBar(this.getBarTitle(), BarColor.GREEN);
    }

    public void run() {
        if (!this.auction.isActive()) {
            this.cancel();
            BossBarUtil.removeAuctionBar();
            return;
        }
        int timeRemaining = this.auction.getTimeRemaining();
        if (timeRemaining <= 0) {
            this.auction.end();
            BossBarUtil.removeAuctionBar();
            this.cancel();
            this.auctionManager.clearActiveAuction();
            return;
        }
        this.updateBossBar(timeRemaining);
    }

    private void updateBossBar(int timeRemaining) {
        double progress = (double)timeRemaining / (double)this.auction.getDuration();
        BossBarUtil.updateAuctionBar(this.getBarTitle(), progress);
        if (timeRemaining <= 5) {
            BossBarUtil.getAuctionBar().setColor(BarColor.RED);
        } else if (timeRemaining <= 15) {
            BossBarUtil.getAuctionBar().setColor(BarColor.YELLOW);
        }
    }

    private String getBarTitle() {
        StringBuilder title = new StringBuilder();
        String rewardName = this.auction.getRewardName();
        rewardName = this.auction.getHighestBidder() != null && rewardName.contains("%player%") ? rewardName.replace("%player%", this.auction.getHighestBidder().getName()) : rewardName.replace("%player%", "Winner");
        title.append("&6").append(rewardName);
        title.append(" &7| &eCurrent Bid: &a").append(this.plugin.getEconomyHandler().format(this.auction.getCurrentBid()));
        if (this.auction.getHighestBidder() != null) {
            title.append(" &7| &eBidder: &a").append(this.auction.getHighestBidder().getName());
        }
        int timeRemaining = this.auction.getTimeRemaining();
        title.append(" &7| &eTime: &a").append(this.formatTime(timeRemaining));
        return title.toString();
    }

    private String formatTime(int seconds) {
        if (seconds < 60) {
            return seconds + "s";
        }
        int minutes = seconds / 60;
        int remainingSeconds = seconds % 60;
        return minutes + "m " + remainingSeconds + "s";
    }

    public void cancelTask() {
        this.cancel();
        BossBarUtil.removeAuctionBar();
    }
}

