/*
 * Decompiled with CFR 0.152.
 */
package org.djtmk.beeauction.commands;

import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.djtmk.beeauction.BeeAuction;
import org.djtmk.beeauction.config.MessageEnum;
import org.djtmk.beeauction.listeners.AuctionChatListener;
import org.djtmk.beeauction.util.MessageUtil;

public class GlobalAuctionCommand
implements CommandExecutor {
    private final BeeAuction plugin;
    private final AuctionChatListener chatListener;

    public GlobalAuctionCommand(BeeAuction plugin) {
        this.plugin = plugin;
        this.chatListener = new AuctionChatListener(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("globalauction.admin")) {
            MessageUtil.sendMessage(sender instanceof Player ? (Player)sender : null, MessageEnum.NO_PERMISSION.get());
            return true;
        }
        if (args.length == 0) {
            this.sendUsage(sender);
            return true;
        }
        String startCmd = this.plugin.getConfigManager().getAdminSubcommandStart();
        String cancelCmd = this.plugin.getConfigManager().getAdminSubcommandCancel();
        String reloadCmd = this.plugin.getConfigManager().getAdminSubcommandReload();
        String subCmd = args[0].toLowerCase();
        if (subCmd.equals(startCmd)) {
            this.handleStart(sender, args);
        } else if (subCmd.equals(cancelCmd)) {
            this.handleCancel(sender);
        } else if (subCmd.equals(reloadCmd)) {
            this.handleReload(sender);
        } else {
            this.sendUsage(sender);
        }
        return true;
    }

    private void handleStart(CommandSender sender, String[] args) {
        double startPrice;
        int duration;
        if (this.plugin.getAuctionManager().hasActiveAuction()) {
            MessageUtil.sendMessage(sender instanceof Player ? (Player)sender : null, MessageEnum.AUCTION_ALREADY_ACTIVE.get());
            return;
        }
        if (args.length < 4) {
            this.sendUsage(sender);
            return;
        }
        String itemType = this.plugin.getConfigManager().getAdminAuctionTypeItem();
        String commandType = this.plugin.getConfigManager().getAdminAuctionTypeCommand();
        String type = args[1].toLowerCase();
        try {
            duration = Integer.parseInt(args[2]);
            if (duration <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            MessageUtil.sendMessage(sender instanceof Player ? (Player)sender : null, MessageEnum.INVALID_COMMAND.get());
            return;
        }
        try {
            startPrice = Double.parseDouble(args[3]);
            if (startPrice <= 0.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            MessageUtil.sendMessage(sender instanceof Player ? (Player)sender : null, MessageEnum.INVALID_COMMAND.get());
            return;
        }
        if (type.equals(itemType)) {
            if (!(sender instanceof Player)) {
                MessageUtil.sendMessage(null, "\u00a7cOnly players can start item auctions");
                return;
            }
            Player player = (Player)sender;
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item == null || item.getType().isAir()) {
                MessageUtil.sendMessage(player, "\u00a7cYou must hold an item to auction");
                return;
            }
            MessageUtil.sendMessage(player, MessageEnum.AUCTION_NAME_QUESTION.get());
            this.chatListener.addPendingItemAuction(player, item.clone(), duration, startPrice);
            item.setAmount(0);
            player.getInventory().setItemInMainHand(item);
        } else if (type.equals(commandType)) {
            if (args.length < 5) {
                this.sendUsage(sender);
                return;
            }
            if (!(sender instanceof Player)) {
                MessageUtil.sendMessage(null, "\u00a7cOnly players can start command auctions");
                return;
            }
            Player player = (Player)sender;
            StringBuilder commandBuilder = new StringBuilder();
            for (int i = 4; i < args.length; ++i) {
                commandBuilder.append(args[i]).append(" ");
            }
            String auctionCommand = commandBuilder.toString().trim();
            MessageUtil.sendMessage(player, MessageEnum.AUCTION_NAME_QUESTION.get());
            this.chatListener.addPendingCommandAuction(player, auctionCommand, duration, startPrice);
        } else {
            this.sendUsage(sender);
        }
    }

    private void handleCancel(CommandSender sender) {
        if (!this.plugin.getAuctionManager().hasActiveAuction()) {
            MessageUtil.sendMessage(sender instanceof Player ? (Player)sender : null, MessageEnum.NO_AUCTION.get());
            return;
        }
        this.plugin.getAuctionManager().cancelAuction();
        MessageUtil.sendMessage(sender instanceof Player ? (Player)sender : null, "\u00a7aAuction cancelled");
    }

    private void handleReload(CommandSender sender) {
        this.plugin.getConfigManager().reloadConfigs();
        if (this.plugin.getConfigManager().isScheduleEnabled()) {
            this.plugin.getAuctionManager().scheduleAutoAuctions();
            this.plugin.getLogger().info("Rescheduled auto auctions after config reload");
        }
        MessageUtil.sendMessage(sender instanceof Player ? (Player)sender : null, MessageEnum.RELOAD_SUCCESS.get());
    }

    private void sendUsage(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            String adminCmd = this.plugin.getConfigManager().getAdminCommandName();
            String startCmd = this.plugin.getConfigManager().getAdminSubcommandStart();
            String cancelCmd = this.plugin.getConfigManager().getAdminSubcommandCancel();
            String reloadCmd = this.plugin.getConfigManager().getAdminSubcommandReload();
            String itemType = this.plugin.getConfigManager().getAdminAuctionTypeItem();
            String commandType = this.plugin.getConfigManager().getAdminAuctionTypeCommand();
            MessageUtil.sendMessage(player, "\u00a76GlobalAuction Commands:");
            MessageUtil.sendMessage(player, "\u00a7e/" + adminCmd + " " + startCmd + " " + itemType + " <time> <start_price> \u00a77- Start an item auction with the item in your hand");
            MessageUtil.sendMessage(player, "\u00a7e/" + adminCmd + " " + startCmd + " " + commandType + " <time> <start_price> <command> \u00a77- Start a command auction");
            MessageUtil.sendMessage(player, "\u00a7e/" + adminCmd + " " + cancelCmd + " \u00a77- Cancel the active auction");
            MessageUtil.sendMessage(player, "\u00a7e/" + adminCmd + " " + reloadCmd + " \u00a77- Reload the config");
            MessageUtil.sendMessage(player, "\u00a77Note: You will be asked to provide a name for the auction after starting it.");
            MessageUtil.sendMessage(player, "");
        }
    }
}

