/*
 * Decompiled with CFR 0.152.
 */
package org.djtmk.beeauction.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.util.StringUtil;
import org.djtmk.beeauction.BeeAuction;

public class GlobalAuctionTabCompleter
implements TabCompleter {
    private final BeeAuction plugin;
    private List<String> COMMANDS;
    private List<String> AUCTION_TYPES;
    private static final List<String> EXAMPLE_TIMES = Arrays.asList("30", "60", "120", "300", "600");
    private static final List<String> EXAMPLE_PRICES = Arrays.asList("100", "500", "1000", "5000");
    private static final List<String> EXAMPLE_COMMANDS = Arrays.asList("give %player% diamond 5", "give %player% emerald 10", "eco give %player% 1000", "crate give %player% rare 1");

    public GlobalAuctionTabCompleter(BeeAuction plugin) {
        this.plugin = plugin;
        this.updateCommandLists();
    }

    private void updateCommandLists() {
        String startCmd = this.plugin.getConfigManager().getAdminSubcommandStart();
        String cancelCmd = this.plugin.getConfigManager().getAdminSubcommandCancel();
        String reloadCmd = this.plugin.getConfigManager().getAdminSubcommandReload();
        this.COMMANDS = Arrays.asList(startCmd, cancelCmd, reloadCmd);
        String itemType = this.plugin.getConfigManager().getAdminAuctionTypeItem();
        String commandType = this.plugin.getConfigManager().getAdminAuctionTypeCommand();
        this.AUCTION_TYPES = Arrays.asList(itemType, commandType);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("globalauction.admin")) {
            return Collections.emptyList();
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            StringUtil.copyPartialMatches((String)args[0], this.COMMANDS, completions);
        } else if (args.length == 2 && args[0].equalsIgnoreCase("start")) {
            StringUtil.copyPartialMatches((String)args[1], this.AUCTION_TYPES, completions);
        } else if (args.length == 3 && args[0].equalsIgnoreCase("start")) {
            StringUtil.copyPartialMatches((String)args[2], EXAMPLE_TIMES, completions);
        } else if (args.length == 4 && args[0].equalsIgnoreCase("start")) {
            StringUtil.copyPartialMatches((String)args[3], EXAMPLE_PRICES, completions);
        } else if (args.length == 5 && args[0].equalsIgnoreCase("start") && args[1].equalsIgnoreCase("command")) {
            StringUtil.copyPartialMatches((String)args[4], EXAMPLE_COMMANDS, completions);
        }
        Collections.sort(completions);
        return completions;
    }
}

