/*
 * Decompiled with CFR 0.152.
 */
package org.djtmk.beeauction.commands;

import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.djtmk.beeauction.BeeAuction;
import org.djtmk.beeauction.config.MessageEnum;
import org.djtmk.beeauction.util.MessageUtil;

public class PodbijCommand
implements CommandExecutor {
    private final BeeAuction plugin;

    public PodbijCommand(BeeAuction plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double amount;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("globalauction.bid")) {
            MessageUtil.sendMessage(player, MessageEnum.NO_PERMISSION.get());
            return true;
        }
        String bidCommand = this.plugin.getConfigManager().getPlayerBidCommand();
        if (args.length == 0) {
            MessageUtil.sendMessage(player, "\u00a7cUsage: /" + bidCommand + " <amount>");
            return true;
        }
        if (!this.plugin.getAuctionManager().hasActiveAuction()) {
            MessageUtil.sendMessage(player, MessageEnum.NO_AUCTION.get());
            return true;
        }
        try {
            amount = Double.parseDouble(args[0]);
            if (amount <= 0.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            MessageUtil.sendMessage(player, MessageEnum.INVALID_AMOUNT.get("amount", this.plugin.getEconomyHandler().format(this.plugin.getAuctionManager().getActiveAuction().getCurrentBid() + 1.0)));
            return true;
        }
        this.plugin.getAuctionManager().placeBid(player, amount);
        return true;
    }
}

