/*
 * Decompiled with CFR 0.152.
 */
package org.djtmk.beeauction.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.djtmk.beeauction.BeeAuction;
import org.djtmk.beeauction.config.AuctionEnum;
import org.djtmk.beeauction.util.MessageUtil;

public class ConfigManager {
    private final BeeAuction plugin;
    private FileConfiguration config;
    private FileConfiguration messagesConfig;
    private File configFile;
    private File messagesFile;
    private static ConfigManager instance;

    public ConfigManager(BeeAuction plugin) {
        this.plugin = plugin;
        instance = this;
    }

    public void loadConfigs() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.matchConfigWithDefaults();
    }

    public void reloadConfigs() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.matchConfigWithDefaults();
    }

    private void matchConfigWithDefaults() {
        InputStream defaultMessagesStream;
        InputStream defaultConfigStream = this.plugin.getResource("config.yml");
        if (defaultConfigStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultConfigStream, StandardCharsets.UTF_8));
            for (Object key : defaultConfig.getKeys(true)) {
                if (this.config.contains((String)key)) continue;
                this.config.set((String)key, defaultConfig.get((String)key));
            }
            try {
                this.config.save(this.configFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + String.valueOf(this.configFile), e);
            }
        }
        if ((defaultMessagesStream = this.plugin.getResource("messages.yml")) != null) {
            YamlConfiguration defaultMessages = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultMessagesStream, StandardCharsets.UTF_8));
            for (String key : defaultMessages.getKeys(true)) {
                if (this.messagesConfig.contains(key)) continue;
                this.messagesConfig.set(key, defaultMessages.get(key));
            }
            try {
                this.messagesConfig.save(this.messagesFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save messages to " + String.valueOf(this.messagesFile), e);
            }
        }
    }

    public static String getMessage(String key) {
        if (instance == null || ConfigManager.instance.messagesConfig == null) {
            return "\u00a7cMessage not found: " + key;
        }
        String message = ConfigManager.instance.messagesConfig.getString(key.toLowerCase().replace('_', '-'));
        if (message == null) {
            return "\u00a7cMessage not found: " + key;
        }
        return MessageUtil.colorize(message);
    }

    public static String getMessage(String key, Object ... placeholders) {
        String message = ConfigManager.getMessage(key);
        if (placeholders.length % 2 != 0) {
            return message;
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            String placeholder = String.valueOf(placeholders[i]);
            String value = String.valueOf(placeholders[i + 1]);
            message = message.replace("{" + placeholder + "}", value);
        }
        return message;
    }

    public AuctionEnum.StorageType getStorageType() {
        return AuctionEnum.StorageType.SQLITE;
    }

    public boolean isScheduleEnabled() {
        return this.config.getBoolean("schedule.enabled", false);
    }

    public String getAdminCommandName() {
        return this.config.getString("commands.admin.name", "globalauction");
    }

    public List<String> getAdminCommandAliases() {
        return this.config.getStringList("commands.admin.aliases");
    }

    public String getAdminSubcommandStart() {
        return this.config.getString("commands.admin.subcommands.start", "start");
    }

    public String getAdminSubcommandCancel() {
        return this.config.getString("commands.admin.subcommands.cancel", "cancel");
    }

    public String getAdminSubcommandReload() {
        return this.config.getString("commands.admin.subcommands.reload", "reload");
    }

    public String getAdminAuctionTypeItem() {
        return this.config.getString("commands.admin.auction-types.item", "item");
    }

    public String getAdminAuctionTypeCommand() {
        return this.config.getString("commands.admin.auction-types.command", "command");
    }

    public String getPlayerBidCommand() {
        return this.config.getString("commands.player.bid", "podbij");
    }

    public List<String> getPlayerBidCommandAliases() {
        return this.config.getStringList("commands.player.bid-aliases");
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }
}

