/*
 * Decompiled with CFR 0.152.
 */
package org.djtmk.beeauction.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.djtmk.beeauction.BeeAuction;
import org.djtmk.beeauction.data.DatabaseHandler;
import org.djtmk.beeauction.data.SQLiteHandler;

public class DatabaseManager {
    private final BeeAuction plugin;
    private DatabaseHandler databaseHandler;

    public DatabaseManager(BeeAuction plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        this.databaseHandler = new SQLiteHandler(this.plugin);
        try {
            this.databaseHandler.initialize();
            this.plugin.getLogger().info("Database initialized with SQLite handler");
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize database", e);
        }
    }

    public void shutdown() {
        if (this.databaseHandler != null) {
            this.databaseHandler.shutdown();
        }
    }

    public void saveAuctionResult(String playerName, double amount, String auctionType, String reward) {
        if (this.databaseHandler != null) {
            this.databaseHandler.saveAuctionResult(playerName, amount, auctionType, reward);
        }
    }

    public ResultSet getAuctionHistory() {
        if (this.databaseHandler != null) {
            try {
                return this.databaseHandler.getAuctionHistory();
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to get auction history", e);
            }
        }
        return null;
    }

    public DatabaseHandler getDatabaseHandler() {
        return this.databaseHandler;
    }
}

