/*
 * Decompiled with CFR 0.152.
 */
package org.djtmk.beeauction.data;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.djtmk.beeauction.BeeAuction;
import org.djtmk.beeauction.data.DatabaseHandler;

public class SQLiteHandler
implements DatabaseHandler {
    private final BeeAuction plugin;
    private File databaseFile;
    private Connection connection;

    public SQLiteHandler(BeeAuction plugin) {
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
        File dataFolder = new File(this.plugin.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        this.databaseFile = new File(dataFolder, "auctions.db");
        this.createTables();
    }

    @Override
    public void shutdown() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error closing SQLite connection", e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            return this.connection;
        }
        try {
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.databaseFile.getAbsolutePath());
            return this.connection;
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("SQLite JDBC driver not found", e);
        }
    }

    @Override
    public void createTables() {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS auction_history (id INTEGER PRIMARY KEY AUTOINCREMENT, player_name VARCHAR(16), amount DOUBLE, auction_type VARCHAR(16), reward TEXT, timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to create tables", e);
        }
    }

    @Override
    public void saveAuctionResult(String playerName, double amount, String auctionType, String reward) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO auction_history (player_name, amount, auction_type, reward) VALUES (?, ?, ?, ?)");){
            statement.setString(1, playerName);
            statement.setDouble(2, amount);
            statement.setString(3, auctionType);
            statement.setString(4, reward);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save auction result", e);
        }
    }

    @Override
    public ResultSet getAuctionHistory() throws SQLException {
        Connection connection = this.getConnection();
        PreparedStatement statement = connection.prepareStatement("SELECT * FROM auction_history ORDER BY timestamp DESC LIMIT 10");
        return statement.executeQuery();
    }
}

