/*
 * Decompiled with CFR 0.152.
 */
package org.djtmk.beeauction.economy;

import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.djtmk.beeauction.BeeAuction;

public class EconomyHandler {
    private Economy economy;
    private final BeeAuction plugin;

    public EconomyHandler(BeeAuction plugin) {
        this.plugin = plugin;
    }

    public EconomyHandler(Economy economy) {
        this.economy = economy;
        this.plugin = BeeAuction.getInstance();
    }

    public void setEconomy(Economy economy) {
        this.economy = economy;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public boolean hasEnough(Player player, double amount) {
        if (this.economy == null || player == null) {
            return false;
        }
        return this.economy.has((OfflinePlayer)player, amount);
    }

    public boolean withdraw(Player player, double amount) {
        if (this.economy == null || player == null) {
            return false;
        }
        EconomyResponse response = this.economy.withdrawPlayer((OfflinePlayer)player, amount);
        return response.transactionSuccess();
    }

    public boolean deposit(Player player, double amount) {
        if (this.economy == null || player == null) {
            return false;
        }
        EconomyResponse response = this.economy.depositPlayer((OfflinePlayer)player, amount);
        return response.transactionSuccess();
    }

    public String format(double amount) {
        if (this.economy == null) {
            return String.format("%.2f", amount);
        }
        return this.economy.format(amount);
    }

    public double getBalance(Player player) {
        if (this.economy == null || player == null) {
            return 0.0;
        }
        return this.economy.getBalance((OfflinePlayer)player);
    }
}

