/*
 * Decompiled with CFR 0.152.
 */
package org.djtmk.beeauction.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.djtmk.beeauction.BeeAuction;

public class AuctionChatListener
implements Listener {
    private final BeeAuction plugin;
    private final Map<UUID, PendingAuction> pendingAuctions = new HashMap<UUID, PendingAuction>();

    public AuctionChatListener(BeeAuction plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (this.pendingAuctions.containsKey(playerUUID)) {
            event.setCancelled(true);
            PendingAuction pendingAuction = this.pendingAuctions.get(playerUUID);
            String auctionName = event.getMessage();
            this.pendingAuctions.remove(playerUUID);
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                if (pendingAuction.isItemAuction()) {
                    this.plugin.getAuctionManager().startItemAuction(pendingAuction.getItem(), pendingAuction.getDuration(), pendingAuction.getStartPrice(), auctionName, pendingAuction.getOwnerName());
                } else {
                    this.plugin.getAuctionManager().startCommandAuction(pendingAuction.getCommand(), pendingAuction.getDuration(), pendingAuction.getStartPrice(), auctionName, pendingAuction.getOwnerName());
                }
            });
        }
    }

    public void addPendingItemAuction(Player player, ItemStack item, int duration, double startPrice) {
        this.pendingAuctions.put(player.getUniqueId(), new PendingAuction(item, duration, startPrice, player.getName()));
    }

    public void addPendingCommandAuction(Player player, String command, int duration, double startPrice) {
        this.pendingAuctions.put(player.getUniqueId(), new PendingAuction(command, duration, startPrice, player.getName()));
    }

    public void removePendingAuction(Player player) {
        this.pendingAuctions.remove(player.getUniqueId());
    }

    private static class PendingAuction {
        private final ItemStack item;
        private final String command;
        private final int duration;
        private final double startPrice;
        private final String ownerName;

        public PendingAuction(ItemStack item, int duration, double startPrice, String ownerName) {
            this.item = item;
            this.command = null;
            this.duration = duration;
            this.startPrice = startPrice;
            this.ownerName = ownerName;
        }

        public PendingAuction(String command, int duration, double startPrice, String ownerName) {
            this.item = null;
            this.command = command;
            this.duration = duration;
            this.startPrice = startPrice;
            this.ownerName = ownerName;
        }

        public boolean isItemAuction() {
            return this.item != null;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public String getCommand() {
            return this.command;
        }

        public int getDuration() {
            return this.duration;
        }

        public double getStartPrice() {
            return this.startPrice;
        }

        public String getOwnerName() {
            return this.ownerName;
        }
    }
}

