/*
 * Decompiled with CFR 0.152.
 */
package org.djtmk.beeauction.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.djtmk.beeauction.util.MessageUtil;

public class ItemUtils {
    public static void serializeItem(ItemStack item, ConfigurationSection section) {
        if (item == null || section == null) {
            return;
        }
        section.set("material", (Object)item.getType().name());
        section.set("amount", (Object)item.getAmount());
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName()) {
                section.set("name", (Object)meta.getDisplayName());
            }
            if (meta.hasLore()) {
                section.set("lore", (Object)meta.getLore());
            }
            if (!meta.getEnchants().isEmpty()) {
                ConfigurationSection enchantSection = section.createSection("enchantments");
                for (Map.Entry entry : meta.getEnchants().entrySet()) {
                    enchantSection.set(((Enchantment)entry.getKey()).getKey().getKey(), entry.getValue());
                }
            }
            if (!meta.getItemFlags().isEmpty()) {
                ArrayList<String> flags = new ArrayList<String>();
                for (ItemFlag flag : meta.getItemFlags()) {
                    flags.add(flag.name());
                }
                section.set("flags", flags);
            }
        }
    }

    public static ItemStack deserializeItem(ConfigurationSection section) {
        ConfigurationSection enchantSection;
        Material material;
        if (section == null) {
            return null;
        }
        String materialName = section.getString("material");
        if (materialName == null) {
            return null;
        }
        try {
            material = Material.valueOf((String)materialName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        int amount = section.getInt("amount", 1);
        ItemStack item = new ItemStack(material, amount);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        if (section.contains("name")) {
            meta.setDisplayName(MessageUtil.colorize(section.getString("name")));
        }
        if (section.contains("lore")) {
            List lore = section.getStringList("lore");
            ArrayList<String> colorizedLore = new ArrayList<String>();
            for (String line : lore) {
                colorizedLore.add(MessageUtil.colorize(line));
            }
            meta.setLore(colorizedLore);
        }
        if (section.contains("enchantments") && (enchantSection = section.getConfigurationSection("enchantments")) != null) {
            for (String key : enchantSection.getKeys(false)) {
                Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)key));
                if (enchantment == null) continue;
                meta.addEnchant(enchantment, enchantSection.getInt(key), true);
            }
        }
        if (section.contains("flags")) {
            List flags = section.getStringList("flags");
            for (String flag : flags) {
                try {
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)flag)});
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    public static String getItemDisplayName(ItemStack item) {
        if (item == null) {
            return "null";
        }
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            return item.getItemMeta().getDisplayName();
        }
        return ItemUtils.formatMaterialName(item.getType().name());
    }

    public static String formatMaterialName(String materialName) {
        if (materialName == null) {
            return "";
        }
        String[] words = materialName.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }
}

