/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.blood;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.chest_item.event.activated.ci.ItemStackAttackEvent;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.jetbrains.annotations.Nullable;

public class GodBlood
extends ItemBase {
    public GodBlood(Item.Properties properties) {
        super(properties);
    }

    public static void attack(ItemStackAttackEvent event) {
        LivingIncomingDamageEvent livingIncomingDamageEvent = event.event;
        Player player = event.player;
        LivingEntity target = livingIncomingDamageEvent.getEntity();
        ChestInventory chestInventory = event.chestInventory;
        if (!player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.God_blood)) continue;
                target.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 100, 1), (Entity)player);
            }
        }
    }

    public static void tick(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (!player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.is(InitItems.God_blood)) {
                    player.getAttributes().addTransientAttributeModifiers(GodBlood.attributeModifierMultimap());
                    break;
                }
                player.getAttributes().removeAttributeModifiers(GodBlood.attributeModifierMultimap());
            }
        }
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMultimap() {
        HashMultimap modifiers = HashMultimap.create();
        modifiers.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.God_blood.asItem().getDescriptionId())), 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        modifiers.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.God_blood.asItem().getDescriptionId())), 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return modifiers;
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> muAttribute(Player player, ItemStack stack) {
        return GodBlood.attributeModifierMultimap();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.god_blood.string.0").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.ITALIC));
        tooltipAdder.accept((Component)Component.literal((String)""));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.god_blood.string.1").withStyle(ChatFormatting.GOLD));
    }

    @Override
    public int color(ItemStack stack) {
        return Light.ARGB.color(255, 100, 100, 255);
    }
}

