/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.other;

import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.other.DataReg;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;

public class Lead
extends ItemBase {
    public static final String lead = "leadNumber";

    public Lead(Item.Properties properties) {
        super(properties);
    }

    public static void event(CriticalHitEvent event) {
        Player player = event.getEntity();
        ChestInventory chestInventory = Handler.getItem(player);
        if (chestInventory != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.Lead_)) continue;
                CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
                if (compoundTag != null) {
                    if (compoundTag.getInt(lead).isPresent()) {
                        compoundTag.putInt(lead, (Integer)compoundTag.getInt(lead).get() + 1);
                        if ((Integer)compoundTag.getInt(lead).get() < 3) continue;
                        event.setDisableSweep(false);
                        event.setCriticalHit(true);
                        event.setDamageMultiplier(event.getDamageMultiplier() * 1.5f);
                        compoundTag.putInt(lead, 0);
                        continue;
                    }
                    compoundTag.putInt(lead, 0);
                    continue;
                }
                stack.set(DataReg.tag, (Object)new CompoundTag());
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.lead.string.0").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.ITALIC));
        tooltipAdder.accept((Component)Component.literal((String)""));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.lead.string.1").withStyle(ChatFormatting.GOLD));
    }

    @Override
    public int color(ItemStack stack) {
        return Light.ARGB.color(255, 0, 0, 255);
    }
}

