/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.other;

import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;

public class SpeedHeart
extends ItemBase {
    public SpeedHeart(Item.Properties properties) {
        super(properties);
    }

    public static void eat(LivingEntityUseItemEvent.Finish event) {
        Player player;
        ChestInventory chestInventory;
        LivingEntity living = event.getEntity();
        if (living instanceof Player && (chestInventory = Handler.getItem(player = (Player)living)) != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                FoodProperties sf;
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.SpeedHeart_) || (sf = (FoodProperties)event.getItem().get(DataComponents.FOOD)) == null) continue;
                float food = sf.nutrition();
                float sta = sf.saturation();
                player.heal((food + sta) / 3.3f);
                break;
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.speed_heart.string.0").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.ITALIC));
        tooltipAdder.accept((Component)Component.literal((String)""));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.speed_heart.string.2").withStyle(ChatFormatting.GOLD));
    }

    @Override
    public int color(ItemStack stack) {
        return Light.ARGB.color(255, 100, 20, 255);
    }
}

