/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.blood;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.renderer.light.Light;
import com.ytgld.chest_item.tip.an_element.SkillList;
import com.ytgld.chest_item.tip.an_element.SkillTooltip;
import com.ytgld.chest_item.tip.an_element.extend.SkillBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LifeCrystal
extends ItemBase
implements SkillList {
    public LifeCrystal(Item.Properties properties) {
        super(properties);
    }

    public static void tick(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (!player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.is(InitItems.Life_Crystal)) {
                    player.getAttributes().addTransientAttributeModifiers(LifeCrystal.attributeModifierMultimap());
                    break;
                }
                player.getAttributes().removeAttributeModifiers(LifeCrystal.attributeModifierMultimap());
            }
        }
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMultimap() {
        HashMultimap modifiers = HashMultimap.create();
        modifiers.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.Life_Crystal.asItem().getDescriptionId())), 10.0, AttributeModifier.Operation.ADD_VALUE));
        return modifiers;
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> muAttribute(Player player, ItemStack stack) {
        return LifeCrystal.attributeModifierMultimap();
    }

    @Override
    @Nullable
    public Map<SkillBase, ResourceLocation> name() {
        HashMap<SkillBase, ResourceLocation> map = new HashMap<SkillBase, ResourceLocation>();
        map.put(pTherapeutic, SkillList.pTherapeutic.baneImage());
        return map;
    }

    @Override
    public Map<SkillBase, Component> tooltip() {
        HashMap<SkillBase, Component> map = new HashMap<SkillBase, Component>();
        map.put(SkillList.pTherapeutic, (Component)Component.translatable((String)("item.chest_item.skill." + pTherapeutic.baneName())));
        return map;
    }

    @Override
    @Nullable
    public Map<SkillBase, Integer> element(ItemStack stack) {
        HashMap<SkillBase, Integer> map = new HashMap<SkillBase, Integer>();
        SkillBase.getElementMap(stack, map, pTherapeutic);
        return map;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new SkillTooltip(this, this, stack));
    }

    @Override
    public int color(ItemStack stack) {
        return Light.ARGB.color(255, 255, 50, 50);
    }
}

