/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.tip.an_element.elements;

import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.other.DataReg;
import com.ytgld.chest_item.tip.an_element.SkillList;
import com.ytgld.chest_item.tip.an_element.extend.SkillBase;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PlagueSpores
extends SkillBase {
    public static void useSkill(Player player) {
        ChestInventory chestInventory = Handler.getItem(player);
        if (chestInventory != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.isEmpty()) continue;
                if (stack.getItem() instanceof SkillList && stack.get(DataReg.tag) == null) {
                    stack.set(DataReg.tag, (Object)new CompoundTag());
                }
                if (!SkillBase.isHasElement(stack, SkillList.pPlagueSpores) || player.getCooldowns().isOnCooldown(stack)) continue;
                int lvl = SkillBase.getHasElementLevel(stack, SkillList.pPlagueSpores);
                Vec3 playerPos = player.position().add(0.0, 0.75, 0.0);
                int range = lvl + 3;
                List entities = player.level().getEntitiesOfClass(LivingEntity.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
                for (LivingEntity entity : entities) {
                    if (entity.is((Entity)player)) continue;
                    entity.addEffect(new MobEffectInstance(MobEffects.POISON, 200 + lvl * 20, 1), (Entity)player);
                }
                SkillBase.addXP(stack, SkillList.pPlagueSpores, 1, 10, 10);
                player.getCooldowns().addCooldown(stack, lvl * 10 + 200);
                break;
            }
        }
    }

    @Override
    public String baneName() {
        return "plague_spores";
    }
}

