/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.black;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.AttReg;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.ItemBlackShadow;
import com.ytgld.chest_item.other.ChestInventory;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class DryBones
extends ItemBlackShadow {
    public DryBones(Item.Properties properties) {
        super(properties);
    }

    public static void ItemStackTickEvent(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (player != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.is(InitItems.DryBones_)) {
                    player.getAttributes().addTransientAttributeModifiers(DryBones.attributeModifierMultimap(player));
                    break;
                }
                player.getAttributes().removeAttributeModifiers(DryBones.attributeModifierMultimap(player));
            }
        }
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMultimap(Player player) {
        HashMultimap modifiers = HashMultimap.create();
        float hyperplasia = ((Float)player.getData(AttReg.hyperplasiaATTACHMENT_TYPES)).floatValue();
        float shadow_shield = ((Float)player.getData(AttReg.shadow_shield_ATTACHMENT_TYPES)).floatValue();
        float a = 0.0f;
        float s = 0.0f;
        float d = 0.0f;
        float f = 0.0f;
        AttributeInstance attributeInstance_hyperplasia = player.getAttribute(AttReg.hyperplasia);
        AttributeInstance attributeInstance_shadow_shield = player.getAttribute(AttReg.shadow_shield);
        if (attributeInstance_hyperplasia != null && attributeInstance_shadow_shield != null) {
            float hV = (float)attributeInstance_hyperplasia.getValue() - 1.0f;
            float vS = (float)attributeInstance_shadow_shield.getValue() - 1.0f;
            if (hyperplasia >= hV && hyperplasia != 0.0f && hV != 0.0f) {
                a = 0.2f;
                s = 0.2f;
            }
            if (shadow_shield >= vS && shadow_shield != 0.0f && vS != 0.0f) {
                d = 0.2f;
                f = 0.2f;
            }
        }
        modifiers.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.DryBones_.asItem().getDescriptionId())), (double)a, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        modifiers.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.DryBones_.asItem().getDescriptionId())), (double)s, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        modifiers.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.DryBones_.asItem().getDescriptionId())), (double)d, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        modifiers.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.DryBones_.asItem().getDescriptionId())), (double)f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return modifiers;
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> muAttribute(Player player, ItemStack stack) {
        return DryBones.attributeModifierMultimap(player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.dry_bones.string.1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
        tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.dry_bones.string.2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
    }
}

