/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.black;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.AttReg;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.ItemBlackShadow;
import com.ytgld.chest_item.other.ChestInventory;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.Nullable;

public class ShadowMint
extends ItemBlackShadow {
    public ShadowMint(Item.Properties properties) {
        super(properties);
    }

    public static void hurtAttacker(LivingDamageEvent.Pre event) {
        Player player;
        ChestInventory chestInventory;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (chestInventory = Handler.getItem(player = (Player)livingEntity)) != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                Entity entity;
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.ShadowMint_) || !((entity = event.getSource().getEntity()) instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                float shadow_shield = ((Float)player.getData(AttReg.shadow_shield_ATTACHMENT_TYPES)).floatValue();
                if (!(shadow_shield > 0.0f)) continue;
                living.hurt(living.damageSources().magic(), 10.0f);
                if (living.isDeadOrDying()) {
                    player.setData(AttReg.shadow_shield_ATTACHMENT_TYPES, (Object)Float.valueOf(shadow_shield + 4.0f));
                    player.heal(4.0f);
                }
                player.setData(AttReg.shadow_shield_ATTACHMENT_TYPES, (Object)Float.valueOf(shadow_shield - 1.0f));
                break;
            }
        }
    }

    public static void ItemStackTickEvent(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (player != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.is(InitItems.ShadowMint_)) {
                    player.getAttributes().addTransientAttributeModifiers(ShadowMint.attributeModifierMultimap());
                    break;
                }
                player.getAttributes().removeAttributeModifiers(ShadowMint.attributeModifierMultimap());
            }
        }
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMultimap() {
        HashMultimap modifiers = HashMultimap.create();
        modifiers.put(AttReg.shadow_shield, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.ShadowMint_.asItem().getDescriptionId() + "aaaaaa")), 10.0, AttributeModifier.Operation.ADD_VALUE));
        modifiers.put(AttReg.shadow_shield, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.ShadowMint_.asItem().getDescriptionId())), 0.4, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        modifiers.put(AttReg.shadow_shield_speed, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.ShadowMint_.asItem().getDescriptionId())), 0.7, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return modifiers;
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> muAttribute(Player player, ItemStack stack) {
        return ShadowMint.attributeModifierMultimap();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.shadow_mint.string.1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
        tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.shadow_mint.string.2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
    }
}

