/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.other;

import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class Kaolinite
extends ItemBase {
    public Kaolinite(Item.Properties properties) {
        super(properties);
    }

    public static void event(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (!player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.Kaolinite_) || player.experienceLevel <= 0 || player.tickCount % 100 != 1) continue;
                Kaolinite.addDamage(player, EquipmentSlot.HEAD);
                Kaolinite.addDamage(player, EquipmentSlot.CHEST);
                Kaolinite.addDamage(player, EquipmentSlot.LEGS);
                Kaolinite.addDamage(player, EquipmentSlot.FEET);
                Kaolinite.addDamage(player, EquipmentSlot.MAINHAND);
            }
        }
    }

    public static void addDamage(Player player, EquipmentSlot slot) {
        ItemStack stack = player.getItemBySlot(slot);
        if (!stack.isEmpty() && stack.getMaxDamage() != 0 && stack.getDamageValue() > 0) {
            stack.setDamageValue(stack.getDamageValue() - 1);
            player.giveExperiencePoints(-1);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipAdder, flag);
        tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.kaolinite.string.0").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.ITALIC));
        tooltipAdder.add((Component)Component.literal((String)""));
        tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.kaolinite.string.1").withStyle(ChatFormatting.GOLD));
    }

    @Override
    public int color(ItemStack stack) {
        return Light.ARGB.color(255, 255, 0, 255);
    }
}

