/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.other;

import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class WindKnife
extends ItemBase {
    public WindKnife(Item.Properties properties) {
        super(properties);
    }

    public static void event(LivingIncomingDamageEvent event) {
        ChestInventory chestInventory;
        Player player;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && !(player = (Player)entity).level().isClientSide() && (chestInventory = Handler.getItem(player)) != null) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is((Item)InitItems.WindKnife_.get())) continue;
                float damage = Mth.nextFloat((RandomSource)RandomSource.create(), (float)0.8f, (float)1.5f);
                if (player.experienceLevel > 10) {
                    event.setAmount(event.getAmount() * 1.5f);
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.AMBIENT, 1.0f, 1.0f);
                    player.giveExperiencePoints(-50);
                    break;
                }
                event.setAmount(event.getAmount() * damage);
                break;
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipAdder, flag);
        tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.wind_knife.string.0").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.ITALIC));
        tooltipAdder.add((Component)Component.literal((String)""));
        tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.wind_knife.string.1").withStyle(ChatFormatting.GOLD));
        tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.wind_knife.string.2").withStyle(ChatFormatting.GOLD));
    }

    @Override
    public int color(ItemStack stack) {
        return Light.ARGB.color(255, 100, 20, 255);
    }
}

