/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.other;

import com.ytgld.chest_item.other.ChestMenuTypes;
import com.ytgld.chest_item.other.ChestSlot;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ChestItemMenu
extends AbstractContainerMenu {
    private static final int SLOTS_PER_ROW = 9;
    private final Container container;
    private final int containerRows;

    public ChestItemMenu(int containerId, Inventory playerInventory, Container container, int rows) {
        super((MenuType)ChestMenuTypes.GENERIC_12.get(), containerId);
        int j1;
        int i1;
        ChestItemMenu.checkContainerSize((Container)container, (int)(rows * 9));
        this.container = container;
        this.containerRows = rows;
        container.startOpen(playerInventory.player);
        int i = (this.containerRows - 4) * 18;
        for (i1 = 0; i1 < this.containerRows; ++i1) {
            for (j1 = 0; j1 < 12; ++j1) {
                this.addSlot(new ChestSlot(container, j1 + i1 * 9, 8 + j1 * 18, 18 + i1 * 18));
            }
        }
        for (i1 = 0; i1 < 3; ++i1) {
            for (j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)playerInventory, j1 + i1 * 9 + 9, 8 + j1 * 18, 103 + i1 * 18 + i));
            }
        }
        for (i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)playerInventory, i1, 8 + i1 * 18, 161 + i));
        }
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < this.containerRows * 9 ? !this.moveItemStackTo(itemstack1, this.containerRows * 9, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.containerRows * 9, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.container.stopOpen(player);
    }

    public Container getContainer() {
        return this.container;
    }

    public int getRowCount() {
        return this.containerRows;
    }
}

