/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.entity;

import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.entity.AttackEndComing;
import com.ytgld.chest_item.entity.Entitys;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.other.DataReg;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndComing
extends TamableAnimal {
    private final List<Vec3> trailPositions = new ArrayList<Vec3>();
    public boolean canLive = true;

    public EndComing(EntityType<? extends EndComing> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.setNoGravity(true);
    }

    public void die(@NotNull DamageSource p_21809_) {
    }

    public List<Vec3> getTrailPositions() {
        return this.trailPositions;
    }

    public void dis() {
        Vec3 playerPos = this.position();
        int range = 10;
        List imperialHematomas = this.level().getEntitiesOfClass(EndComing.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
        for (EndComing imperialHematoma : imperialHematomas) {
            if (imperialHematoma.getOwner() == null || this.getOwner() == null || imperialHematoma.is((Entity)this) || !imperialHematoma.getOwner().is((Entity)this.getOwner())) continue;
            imperialHematoma.discard();
            return;
        }
    }

    public boolean isHasEffectEnd() {
        Player player;
        ChestInventory chestInventory;
        LivingEntity livingEntity;
        if (this.getOwner() != null && (livingEntity = this.getOwner()) instanceof Player && (chestInventory = Handler.getItem(player = (Player)livingEntity)) != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.EndEffect_)) continue;
                return true;
            }
        }
        return false;
    }

    public void tick() {
        Vec3 forward;
        Vec3 targetPos;
        super.tick();
        this.setNoGravity(true);
        this.dis();
        if (this.getOwner() == null) {
            this.discard();
        }
        LivingEntity owner = this.getOwner();
        LivingEntity target = this.getTarget();
        Vec3 currentPos = this.position();
        if (target != null) {
            Vec3 targetPos2 = target.position().add(0.0, 0.5, 0.0);
            Vec3 direction = targetPos2.subtract(currentPos).normalize();
            this.setDeltaMovement(direction.x * 0.5750000029802322, direction.y * 0.5750000029802322, direction.z * 0.5750000029802322);
        }
        if (owner != null) {
            double desiredDistance = 2.0;
            targetPos = owner.position().add(0.0, 3.0, -1.5);
            forward = owner.getLookAngle();
            Vec3 direction = forward.scale(-1.0).normalize();
            Vec3 newTargetPos = targetPos.add(direction.scale(desiredDistance));
            Level level = owner.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.teleportTo(serverLevel, newTargetPos.x, newTargetPos.y, newTargetPos.z, Set.of(), this.getYRot(), this.getXRot(), false);
            }
        }
        this.trailPositions.add(new Vec3(this.getX(), this.getY(), this.getZ()));
        if (this.trailPositions.size() > 30) {
            this.trailPositions.removeFirst();
        }
        if (this.getTarget() != null && this.getOwner() != null && this.getTarget().is((Entity)this.getOwner())) {
            this.setTarget(null);
        }
        if (this.getTarget() != null && !this.getTarget().isAlive()) {
            this.setTarget(null);
        }
        float s = 5.0f;
        if (this.isHasEffectEnd()) {
            s += 10.0f;
        }
        if (s < 1.0f) {
            s = 1.0f;
        }
        if (this.getOwner() != null && this.getOwner() instanceof Player && this.getTarget() != null) {
            AttackEndComing attackBlood;
            if (this.tickCount % (int)s == 0) {
                attackBlood = new AttackEndComing((EntityType<? extends AttackEndComing>)((EntityType)Entitys.AttackEndComing_.get()), this.level());
                attackBlood.setTarget(this.getTarget());
                if (this.isHasEffectEnd()) {
                    attackBlood.damages += 3.0f;
                }
                attackBlood.setPos(this.position());
                attackBlood.setOwner((Entity)this.getOwner());
                attackBlood.follow = false;
                this.level().addFreshEntity((Entity)attackBlood);
                this.playRemoveOneSound((Entity)this);
            }
            if ((float)this.tickCount % s * 2.0f == 0.0f) {
                attackBlood = new AttackEndComing((EntityType<? extends AttackEndComing>)((EntityType)Entitys.AttackEndComing_.get()), this.level());
                attackBlood.setTarget(this.getTarget());
                if (this.isHasEffectEnd()) {
                    attackBlood.damages += 5.0f;
                }
                attackBlood.setPos(this.position());
                attackBlood.setOwner((Entity)this.getOwner());
                attackBlood.follow = true;
                attackBlood.setDeltaMovement(new Vec3((double)Mth.nextFloat((RandomSource)RandomSource.create(), (float)-0.5f, (float)0.5f), (double)Mth.nextFloat((RandomSource)RandomSource.create(), (float)-0.5f, (float)0.5f), (double)Mth.nextFloat((RandomSource)RandomSource.create(), (float)-0.5f, (float)0.5f)));
                this.level().addFreshEntity((Entity)attackBlood);
                this.playRemoveOneSound((Entity)this);
            }
        }
        if (this.getOwner() != null && (targetPos = this.getOwner()) instanceof Player) {
            Player player = (Player)targetPos;
            if (!this.isHasEffectEnd()) {
                forward = this.look(player.level(), (LivingEntity)player);
                if (forward instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)forward;
                    if (!living.is((Entity)this)) {
                        this.setTarget(living);
                    }
                } else {
                    this.setTarget(null);
                }
            } else {
                Vec3 playerPos = this.position();
                int range = 20;
                List entities = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
                for (LivingEntity living : entities) {
                    if (this.getTarget() != null || living == player || living instanceof EndComing) continue;
                    this.setTarget(living);
                }
            }
        }
        if (target != null && currentPos.distanceTo(target.position()) > 30.0) {
            this.setTarget(null);
        }
        this.clear();
    }

    private void clear() {
        Player player;
        ChestInventory chestInventory;
        LivingEntity livingEntity;
        if (this.canLive && this.getOwner() != null && (livingEntity = this.getOwner()) instanceof Player && (chestInventory = Handler.getItem(player = (Player)livingEntity)) != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.is(InitItems.TheEndIsComing_)) {
                    this.canLive = true;
                    CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
                    if (compoundTag != null && !compoundTag.getBooleanOr("ChestHasEndComing", false)) {
                        this.canLive = false;
                    }
                    return;
                }
                this.canLive = false;
            }
        }
        if (!this.canLive) {
            this.discard();
        }
    }

    public Entity look(Level level, LivingEntity living) {
        Entity pointedEntity = null;
        double range = 20.0;
        Vec3 srcVec = living.getEyePosition();
        Vec3 lookVec = living.getViewVector(1.0f);
        Vec3 destVec = srcVec.add(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range);
        float var9 = 1.0f;
        List possibleList = level.getEntities((Entity)living, living.getBoundingBox().expandTowards(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range).inflate((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.isPickable()) continue;
            float borderSize = possibleEntity.getPickRadius();
            AABB collisionBB = possibleEntity.getBoundingBox().inflate((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.clip(srcVec, destVec);
            if (collisionBB.contains(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.distanceTo((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    private boolean isMoon(LivingEntity living) {
        if (living != null) {
            OwnableEntity entity;
            if (living instanceof OwnableEntity && (entity = (OwnableEntity)living).getOwner() != null && this.getOwner() != null && entity.getOwner().is((Entity)this.getOwner())) {
                return false;
            }
            entity = BuiltInRegistries.ENTITY_TYPE.getKey((Object)living.getType());
            return !entity.getNamespace().equals("chest_item");
        }
        return true;
    }

    private void playRemoveOneSound(Entity p_186343_) {
        p_186343_.playSound(SoundEvents.WARDEN_HEARTBEAT, 0.8f, 0.8f + p_186343_.level().getRandom().nextFloat() * 0.4f);
    }

    public boolean isFood(ItemStack pStack) {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean attackable() {
        return false;
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        return false;
    }

    public boolean canAttack(LivingEntity target) {
        return false;
    }

    public boolean hurtServer(ServerLevel p_376221_, DamageSource p_376460_, float p_376610_) {
        return false;
    }

    protected void doPush(Entity p_27415_) {
    }

    protected void pushEntities() {
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }
}

