/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.meet;

import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.items.Meat;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;

public class Stomach
extends ItemBase
implements Meat {
    public Stomach(Item.Properties properties) {
        super(properties);
    }

    public static void tick(LivingEntityUseItemEvent.Finish event) {
        Player player;
        ChestInventory chestInventory;
        LivingEntity living = event.getEntity();
        if (living instanceof Player && (chestInventory = Handler.getItem(player = (Player)living)) != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.Stomach_) || event.getItem().getUseAnimation() != ItemUseAnimation.EAT) continue;
                player.getFoodData().eat(-10, -10.0f);
                break;
            }
        }
    }

    public static void tick(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (!player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.Stomach_) || player.tickCount % 60 != 0) continue;
                player.getFoodData().eat(1, 0.5f);
                break;
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.stomach.string.0").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.ITALIC));
        tooltipAdder.accept((Component)Component.literal((String)""));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.stomach.string.1").withStyle(ChatFormatting.GOLD));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.stomach.string.2").withStyle(ChatFormatting.GOLD));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.stomach.string.3").withStyle(ChatFormatting.GOLD));
    }

    @Override
    public int color(ItemStack stack) {
        return Light.ARGB.color(255, 255, 135, 105);
    }
}

