/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.other;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public record ItemAttributeModifiers(List<Entry> modifiers) {
    public static final ItemAttributeModifiers EMPTY = new ItemAttributeModifiers(List.of());
    public static final Codec<ItemAttributeModifiers> CODEC = Entry.CODEC.listOf().xmap(ItemAttributeModifiers::new, ItemAttributeModifiers::modifiers);

    public void forEach(BiConsumer<Holder<Attribute>, AttributeModifier> action) {
        for (Entry itemattributemodifiers$entry : this.modifiers) {
            action.accept(itemattributemodifiers$entry.attribute, itemattributemodifiers$entry.modifier);
        }
    }

    public record Entry(Holder<Attribute> attribute, AttributeModifier modifier) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(p_419448_ -> p_419448_.group((App)Attribute.CODEC.fieldOf("type").forGetter(Entry::attribute), (App)AttributeModifier.MAP_CODEC.forGetter(Entry::modifier)).apply((Applicative)p_419448_, Entry::new));
    }

    public static class Builder {
        private final ImmutableList.Builder<Entry> entries = ImmutableList.builder();

        public Builder add(Holder<Attribute> attribute, AttributeModifier modifier) {
            this.entries.add((Object)new Entry(attribute, modifier));
            return this;
        }

        public ItemAttributeModifiers build() {
            return new ItemAttributeModifiers((List<Entry>)this.entries.build());
        }
    }
}

