/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.entity;

import com.ytgld.chest_item.tip.an_element.elements.DoomsdayJudgment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AttackEndComing
extends ThrowableItemProjectile {
    private LivingEntity target;
    private final List<Vec3> trailPositions = new ArrayList<Vec3>();
    public float damages = 4.0f;
    public float addDamgae = 0.0f;
    public float speeds = 2.0f;
    public boolean follow;
    public int live = 50;
    public boolean canSee = true;

    public AttackEndComing(EntityType<? extends AttackEndComing> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
    }

    public boolean isInWater() {
        return false;
    }

    public boolean onGround() {
        return false;
    }

    protected void onHitBlock(BlockHitResult result) {
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    public List<Vec3> getTrailPositions() {
        return this.trailPositions;
    }

    protected Item getDefaultItem() {
        return Items.ENDER_PEARL;
    }

    @NotNull
    public ItemStack getItem() {
        return Items.ENDER_PEARL.getDefaultInstance();
    }

    public float getXRot() {
        return 0.0f;
    }

    public void move(MoverType type, Vec3 movement) {
    }

    public float getYRot() {
        return 0.0f;
    }

    public void attack() {
        Vec3 playerPos = this.position().add(0.0, 0.75, 0.0);
        int range = 2;
        if (this.canSee) {
            List entities = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
            for (LivingEntity entity : entities) {
                Entity entity2;
                if (this.getOwner() == null || entity.is(this.getOwner()) || !((entity2 = this.getOwner()) instanceof Player)) continue;
                Player player = (Player)entity2;
                ResourceLocation entitys = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
                if (entitys.getNamespace().equals("chest_item")) continue;
                if (entity.isAlive()) {
                    OwnableEntity ownableEntity;
                    entity.invulnerableTime = 0;
                    if (entity instanceof OwnableEntity && (ownableEntity = (OwnableEntity)entity).getOwner() != null && ownableEntity.getOwner().is(this.getOwner())) {
                        this.canSee = false;
                        return;
                    }
                    float damageDoomsdayJudgment = (float)((double)(this.damages + this.addDamgae + player.getMaxHealth() / 10.0f) + player.getAttributeValue(Attributes.ATTACK_DAMAGE) / 10.0);
                    entity.hurt(this.getOwner().damageSources().playerAttack(player), damageDoomsdayJudgment *= DoomsdayJudgment.damageModify((LivingEntity)player));
                    DoomsdayJudgment.useSkill(this.getOwner());
                    if (this.follow) {
                        this.level().addParticle((ParticleOptions)ParticleTypes.SONIC_BOOM, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                    }
                    this.canSee = false;
                    continue;
                }
                this.canSee = false;
            }
        }
    }

    public void tick() {
        super.tick();
        this.setNoGravity(true);
        this.noPhysics = true;
        if (this.canSee) {
            if (this.tickCount > 100) {
                if (this.follow) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.SONIC_BOOM, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                }
                this.canSee = false;
            }
            if (this.target != null && !this.target.isAlive()) {
                this.findNewTarget();
            }
        }
        float s = 0.175f;
        if (this.canSee) {
            if (this.target != null) {
                if (this.follow) {
                    if (this.tickCount > 10) {
                        if (!DoomsdayJudgment.isHas(this.getOwner())) {
                            Vec3 targetPos = this.target.position().add(0.0, 1.0, 0.0);
                            Vec3 currentPos = this.position();
                            Vec3 direction = targetPos.subtract(currentPos).normalize();
                            Vec3 currentDirection = this.getDeltaMovement().normalize();
                            double angle = Math.acos(currentDirection.dot(direction)) * 57.29577951308232;
                            if (angle > 10.0) {
                                double angleLimit = Math.toRadians(10.0);
                                Vec3 limitedDirection = currentDirection.scale(Math.cos(angleLimit)).add(direction.normalize().scale(Math.sin(angleLimit)));
                                this.setDeltaMovement(limitedDirection.x * (double)(0.125f + s), limitedDirection.y * (double)(0.125f + s), limitedDirection.z * (double)(0.125f + s));
                            } else {
                                this.setDeltaMovement(direction.x * (double)(0.125f + s), direction.y * (double)(0.125f + s), direction.z * (double)(0.125f + s));
                            }
                        } else {
                            Vec3 targetPos = this.target.position().add(0.0, 1.0, 0.0);
                            this.setPos(targetPos);
                        }
                    }
                } else if (this.tickCount == 2) {
                    if (!DoomsdayJudgment.isHas(this.getOwner())) {
                        Vec3 targetPos = this.target.position().add(0.0, 0.5, 0.0);
                        Vec3 currentPos = this.position();
                        Vec3 direction = targetPos.subtract(currentPos).normalize();
                        this.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3(targetPos.x, targetPos.y, targetPos.z));
                        this.lookAt(EntityAnchorArgument.Anchor.FEET, new Vec3(targetPos.x, targetPos.y, targetPos.z));
                        this.setDeltaMovement(direction.x * (double)(this.speeds + s), direction.y * (double)(this.speeds + s), direction.z * (double)(this.speeds + s));
                    } else {
                        Vec3 targetPos = this.target.position().add(0.0, 1.0, 0.0);
                        this.setPos(targetPos);
                    }
                }
            }
        } else {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
        if (this.canSee) {
            this.trailPositions.add(new Vec3(this.getX(), this.getY(), this.getZ()));
        }
        if (!(this.trailPositions.isEmpty() || this.trailPositions.size() <= 16 && this.canSee)) {
            this.trailPositions.removeFirst();
        }
        if (!this.canSee) {
            --this.live;
        }
        if (this.live <= 0) {
            this.discard();
        }
        this.setNoGravity(true);
        this.attack();
    }

    private void findNewTarget() {
        AABB searchBox = this.getBoundingBox().inflate(16.0);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, searchBox);
        double closestDistance = Double.MAX_VALUE;
        LivingEntity closestEntity = null;
        for (LivingEntity entity : entities) {
            double distance;
            ResourceLocation name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            if (this.getOwner() == null || name.getNamespace().equals("chest_item") || entity.is(this.getOwner()) || !((distance = this.distanceToSqr((Entity)entity)) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        this.target = closestEntity;
    }
}

