/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.entity.c;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ytgld.chest_item.ChestitemClient;
import com.ytgld.chest_item.ConfigC;
import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.entity.AttackEndComing;
import com.ytgld.chest_item.renderer.MRender;
import com.ytgld.chest_item.renderer.MoonPost;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AttackEndComingRenderer
extends EntityRenderer<AttackEndComing> {
    public AttackEndComingRenderer(EntityRendererProvider.Context p_173917_) {
        super(p_173917_);
    }

    public boolean shouldRender(AttackEndComing livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public void render(AttackEndComing entity, float p_114486_, float p_114487_, PoseStack poseStack, MultiBufferSource bufferSource, int p_114490_) {
        super.render((Entity)entity, p_114486_, p_114487_, poseStack, bufferSource, p_114490_);
        if (((Boolean)ConfigC.config.Render.get()).booleanValue()) {
            MoonPost.renderEffectForNextTick(ChestitemClient.POST_Blood);
        }
        double x = Mth.lerp((double)p_114487_, (double)entity.xOld, (double)entity.getX());
        double y = Mth.lerp((double)p_114487_, (double)entity.yOld, (double)entity.getY());
        double z = Mth.lerp((double)p_114487_, (double)entity.zOld, (double)entity.getZ());
        poseStack.pushPose();
        poseStack.translate(entity.getX() - x, entity.getY() - y, entity.getZ() - z);
        this.setT(poseStack, entity, bufferSource);
        poseStack.popPose();
        if (entity.canSee) {
            this.renderSphere1(poseStack, bufferSource, 240, 0.15f);
        }
    }

    private void setT(PoseStack matrices, AttackEndComing entity, MultiBufferSource vertexConsumers) {
        matrices.pushPose();
        for (int i = 1; i < entity.getTrailPositions().size(); ++i) {
            Vec3 prevPos = entity.getTrailPositions().get(i - 1);
            Vec3 currPos = entity.getTrailPositions().get(i);
            Vec3 adjustedPrevPos = new Vec3(prevPos.x - entity.getX(), prevPos.y - entity.getY(), prevPos.z - entity.getZ());
            Vec3 adjustedCurrPos = new Vec3(currPos.x - entity.getX(), currPos.y - entity.getY(), currPos.z - entity.getZ());
            float alpha = (float)i / (float)entity.getTrailPositions().size();
            Handler.renderBlood(matrices.last(), vertexConsumers.getBuffer(MRender.LIGHTNING), adjustedPrevPos, adjustedCurrPos, alpha, alpha / 10.0f);
            Handler.renderBlood(matrices.last(), vertexConsumers.getBuffer(MRender.LIGHTNING_Outline), adjustedPrevPos, adjustedCurrPos, alpha, alpha / 10.0f);
        }
        matrices.popPose();
    }

    public void renderSphere1(@NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, float s) {
        float z3;
        float y3;
        float x3;
        float z2;
        float y2;
        float x2;
        float z1;
        float y1;
        float x1;
        float z0;
        float y0;
        float x0;
        float theta1;
        float theta0;
        int j;
        float phi1;
        float phi0;
        int i;
        int stacks = 20;
        int slices = 20;
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(MRender.LIGHTNING);
        for (i = 0; i < stacks; ++i) {
            phi0 = (float)Math.PI * ((float)(i + 0) / (float)stacks);
            phi1 = (float)Math.PI * ((float)(i + 1) / (float)stacks);
            for (j = 0; j < slices; ++j) {
                theta0 = (float)Math.PI * 2 * ((float)(j + 0) / (float)slices);
                theta1 = (float)Math.PI * 2 * ((float)(j + 1) / (float)slices);
                x0 = s * (float)Math.sin(phi0) * (float)Math.cos(theta0);
                y0 = s * (float)Math.cos(phi0);
                z0 = s * (float)Math.sin(phi0) * (float)Math.sin(theta0);
                x1 = s * (float)Math.sin(phi0) * (float)Math.cos(theta1);
                y1 = s * (float)Math.cos(phi0);
                z1 = s * (float)Math.sin(phi0) * (float)Math.sin(theta1);
                x2 = s * (float)Math.sin(phi1) * (float)Math.cos(theta1);
                y2 = s * (float)Math.cos(phi1);
                z2 = s * (float)Math.sin(phi1) * (float)Math.sin(theta1);
                x3 = s * (float)Math.sin(phi1) * (float)Math.cos(theta0);
                y3 = s * (float)Math.cos(phi1);
                z3 = s * (float)Math.sin(phi1) * (float)Math.sin(theta0);
                vertexConsumer.addVertex(matrices.last().pose(), x0, y0, z0).setColor(1.0f, 0.0f, 0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrices.last().pose(), x1, y1, z1).setColor(1.0f, 0.0f, 0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrices.last().pose(), x2, y2, z2).setColor(1.0f, 0.0f, 0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrices.last().pose(), x3, y3, z3).setColor(1.0f, 0.0f, 0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
            }
        }
        stacks = 20;
        slices = 20;
        vertexConsumer = vertexConsumers.getBuffer(MRender.LIGHTNING_Outline);
        for (i = 0; i < stacks; ++i) {
            phi0 = (float)Math.PI * ((float)(i + 0) / (float)stacks);
            phi1 = (float)Math.PI * ((float)(i + 1) / (float)stacks);
            for (j = 0; j < slices; ++j) {
                theta0 = (float)Math.PI * 2 * ((float)(j + 0) / (float)slices);
                theta1 = (float)Math.PI * 2 * ((float)(j + 1) / (float)slices);
                x0 = s * (float)Math.sin(phi0) * (float)Math.cos(theta0);
                y0 = s * (float)Math.cos(phi0);
                z0 = s * (float)Math.sin(phi0) * (float)Math.sin(theta0);
                x1 = s * (float)Math.sin(phi0) * (float)Math.cos(theta1);
                y1 = s * (float)Math.cos(phi0);
                z1 = s * (float)Math.sin(phi0) * (float)Math.sin(theta1);
                x2 = s * (float)Math.sin(phi1) * (float)Math.cos(theta1);
                y2 = s * (float)Math.cos(phi1);
                z2 = s * (float)Math.sin(phi1) * (float)Math.sin(theta1);
                x3 = s * (float)Math.sin(phi1) * (float)Math.cos(theta0);
                y3 = s * (float)Math.cos(phi1);
                z3 = s * (float)Math.sin(phi1) * (float)Math.sin(theta0);
                vertexConsumer.addVertex(matrices.last().pose(), x0, y0, z0).setColor(1.0f, 0.0f, 0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrices.last().pose(), x1, y1, z1).setColor(1.0f, 0.0f, 0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrices.last().pose(), x2, y2, z2).setColor(1.0f, 0.0f, 0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrices.last().pose(), x3, y3, z3).setColor(1.0f, 0.0f, 0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
            }
        }
    }

    public ResourceLocation getTextureLocation(AttackEndComing p_114482_) {
        return ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"null");
    }
}

