/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.tip;

import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.other.DataReg;
import com.ytgld.chest_item.tip.an_element.SkillList;
import com.ytgld.chest_item.tip.an_element.elements.Decisively;
import com.ytgld.chest_item.tip.an_element.elements.Hyperplasia;
import com.ytgld.chest_item.tip.an_element.elements.PlagueDivinePower;
import com.ytgld.chest_item.tip.an_element.elements.Rotten;
import com.ytgld.chest_item.tip.an_element.elements.TerriblePotion;
import com.ytgld.chest_item.tip.an_element.elements.Therapeutic;
import com.ytgld.chest_item.tip.an_element.extend.SkillBase;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class SkillEvent {
    @SubscribeEvent
    public void AddAttributeTooltipsEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        TooltipFlag flag = event.getFlags();
        if (player != null && flag.hasShiftDown()) {
            Item item = stack.getItem();
            if (item instanceof SkillList) {
                SkillList skillList = (SkillList)item;
                item = stack.getItem();
                if (item instanceof ItemBase) {
                    ItemBase itemBase = (ItemBase)item;
                    Map<SkillBase, Integer> map = skillList.element(stack);
                    if (map != null) {
                        for (SkillBase base : map.keySet()) {
                            String text = base.baneName();
                            int lvl = SkillBase.getHasElementLevel(stack, base);
                            float s = (float)(++lvl) * base.aneLvlForModify();
                            String p = "";
                            if (base.isPercentage()) {
                                p = "%";
                                s *= 100.0f;
                            }
                            int color = itemBase.color(stack);
                            event.getToolTip().add(1, Component.translatable((String)("item.chest_item.skill." + base.baneName())).append(": ").append((Component)Component.translatable((String)("item.chest_item.skill." + text + ".text"))).append((Component)Component.literal((String)String.valueOf(s)).append(p)).withStyle(Style.EMPTY.withColor(color)));
                        }
                    }
                }
            }
        } else if (stack.getItem() instanceof SkillList) {
            event.getToolTip().add(1, Component.translatable((String)"key.keyboard.left.shift").withStyle(ChatFormatting.GOLD));
        }
    }

    @SubscribeEvent
    public void LivingIncomingDamageEvent(LivingDamageEvent.Pre event) {
        ChestInventory chestInventory;
        Player player;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && !(player = (Player)entity).level().isClientSide() && (chestInventory = Handler.getItem(player)) != null) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.getItem() instanceof SkillList && stack.get(DataReg.tag) == null) {
                    stack.set(DataReg.tag, (Object)new CompoundTag());
                }
                PlagueDivinePower.PlagueDivinePowerAttack(event, stack);
                Decisively.useSkill(event, stack);
            }
        }
    }

    @SubscribeEvent
    public void tick(ItemStackTickEvent event) {
        Therapeutic.pPlagueSpores(event);
        TerriblePotion.pTerriblePotion(event);
        Hyperplasia.pHyperplasia(event);
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (!player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!(stack.getItem() instanceof SkillList)) continue;
                if (stack.get(DataReg.tag) == null) {
                    stack.set(DataReg.tag, (Object)new CompoundTag());
                }
                Rotten.pRotten(player, stack);
            }
        }
    }
}

