/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.tip.an_element;

import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.other.DataReg;
import com.ytgld.chest_item.tip.an_element.SkillList;
import com.ytgld.chest_item.tip.an_element.extend.BlackSkill;
import com.ytgld.chest_item.tip.an_element.extend.SkillBase;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SkillTooltip
implements ClientTooltipComponent,
TooltipComponent {
    private final SkillList element;
    private final ItemBase itemBase;
    private final ItemStack stack;

    public SkillTooltip(SkillList contents, ItemBase itemBase, ItemStack stack) {
        this.element = contents;
        this.itemBase = itemBase;
        this.stack = stack;
    }

    public int getHeight() {
        return this.backgroundHeight() + 4;
    }

    public int getWidth(@NotNull Font font) {
        return this.backgroundWidth();
    }

    private int backgroundWidth() {
        return this.gridSizeX() * 32;
    }

    private int backgroundHeight() {
        return this.gridSizeY() * 32;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        int i = this.gridSizeX();
        int j = this.gridSizeY();
        int s = 0;
        for (int l = 0; l < j; ++l) {
            for (int i1 = 0; i1 < i; ++i1) {
                int j1 = x + i1 * 32;
                int k1 = y + l * 32;
                this.renderSlot(font, j1, k1, guiGraphics, ++s);
            }
        }
    }

    private void renderSlot(Font font, int x, int y, GuiGraphics guiGraphics, int i) {
        SkillBase elt;
        --i;
        Map<SkillBase, ResourceLocation> resourceLocationMap = this.element.name();
        Map<SkillBase, Integer> map = this.element.element(this.stack);
        Map<SkillBase, Component> stringMap = this.element.tooltip();
        if (resourceLocationMap != null) {
            elt = (SkillBase)resourceLocationMap.keySet().stream().toList().get(i);
            ResourceLocation resourceLocation1 = resourceLocationMap.get(elt);
            guiGraphics.blitSprite(resourceLocation1, x, y, 32, 32);
            if (!(elt instanceof BlackSkill)) {
                guiGraphics.blitSprite(ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"frame"), x, y, 32, 32);
            } else {
                guiGraphics.blitSprite(ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"frame_black"), x, y, 32, 32);
            }
        }
        if (stringMap != null) {
            elt = (SkillBase)stringMap.keySet().stream().toList().get(i);
            Component component = stringMap.get(elt);
            guiGraphics.drawString(font, component, x + 35, y, this.itemBase.color(this.stack), false);
        }
        if (map != null) {
            elt = (SkillBase)map.keySet().stream().toList().get(i);
            int number = map.get(elt);
            guiGraphics.drawString(font, (Component)Component.translatable((String)"item.chest_item.skill.level").append(": ").append((Component)Component.translatable((String)("enchantment.level." + ++number))), x + 35, y + 10, this.itemBase.color(this.stack), false);
            String baneName = elt.baneName();
            String mixinName = baneName + "SkillBaseXP";
            int sx = 0;
            CompoundTag compoundTag = (CompoundTag)this.stack.get(DataReg.tag);
            if (compoundTag != null) {
                sx = compoundTag.getInt(mixinName);
            }
            guiGraphics.drawString(font, (Component)Component.translatable((String)"item.chest_item.skill.xp").append(": ").append(String.valueOf(sx)), x + 35, y + 20, this.itemBase.color(this.stack), false);
        }
    }

    private int gridSizeX() {
        return 1;
    }

    private int gridSizeY() {
        Map<SkillBase, Integer> map = this.element.element(this.stack);
        if (map != null) {
            return map.size();
        }
        return 0;
    }
}

