/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.black.soul;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.TheImprintOfTheSoul;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import org.jetbrains.annotations.Nullable;

public class Glutton
extends TheImprintOfTheSoul {
    public Glutton(Item.Properties properties) {
        super(properties);
    }

    public static void eatStart(LivingEntityUseItemEvent.Start event) {
        Player player;
        ChestInventory chestInventory;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (chestInventory = Handler.getItem(player = (Player)livingEntity)) != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.Glutton_) || event.getItem().getUseAnimation() != UseAnim.EAT) continue;
                event.setDuration(event.getDuration() / 2);
                break;
            }
        }
    }

    public static void eatFinish(LivingEntityUseItemEvent.Finish event) {
        Player player;
        ChestInventory chestInventory;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (chestInventory = Handler.getItem(player = (Player)livingEntity)) != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                FoodProperties sf;
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.Glutton_) || event.getItem().getUseAnimation() != UseAnim.EAT || (sf = (FoodProperties)event.getItem().get(DataComponents.FOOD)) == null) continue;
                float food = sf.nutrition();
                float sta = sf.saturation();
                player.heal(food + sta);
                player.getCooldowns().addCooldown(stack.getItem(), 200);
                break;
            }
        }
    }

    public static void attrib(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (player != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.is(InitItems.Glutton_)) {
                    player.getAttributes().addTransientAttributeModifiers(Glutton.attributeModifierMultimap(player));
                    if (player.tickCount % 200 != 1 || player.getCooldowns().isOnCooldown(stack.getItem())) break;
                    player.getFoodData().eat(-1, 0.5f);
                    break;
                }
                player.getAttributes().removeAttributeModifiers(Glutton.attributeModifierMultimap(player));
            }
        }
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMultimap(Player player) {
        HashMultimap modifiers = HashMultimap.create();
        float hunger = 0.0f;
        float speed = 0.0f;
        if (player.getFoodData().getFoodLevel() > 12) {
            hunger = 10.0f;
            if (player.getFoodData().getFoodLevel() >= 20) {
                speed = -0.25f;
            }
        }
        modifiers.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.Glutton_.asItem().getDescriptionId())), (double)speed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        modifiers.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.Glutton_.asItem().getDescriptionId())), (double)hunger, AttributeModifier.Operation.ADD_VALUE));
        modifiers.put((Object)Attributes.MAX_ABSORPTION, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.Glutton_.asItem().getDescriptionId())), (double)hunger, AttributeModifier.Operation.ADD_VALUE));
        return modifiers;
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> muAttribute(Player player, ItemStack stack) {
        return Glutton.attributeModifierMultimap(player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.glutton.string.1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))).withStyle(ChatFormatting.ITALIC));
        tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.glutton.string.2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
        tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.glutton.string.3").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
        tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.glutton.string.4").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
        tooltipComponents.add((Component)Component.literal((String)""));
        tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.glutton.string.5").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-8371969))).withStyle(ChatFormatting.ITALIC));
        tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.glutton.string.6").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-8371969))));
        tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.glutton.string.7").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-8371969))));
        tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.glutton.string.8").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-8371969))));
    }

    @Override
    public ResourceLocation resourceLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"textures/gui/soul/glutton.png");
    }

    @Override
    public int soulColor() {
        return Light.ARGB.color(255, 255, 255, 60);
    }
}

