/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.black.soul;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.TheImprintOfTheSoul;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.other.DataReg;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.jetbrains.annotations.Nullable;

public class Mutation
extends TheImprintOfTheSoul {
    public Mutation(Item.Properties properties) {
        super(properties);
    }

    public static void attrib(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (player != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.is(InitItems.Mutation_)) {
                    player.getAttributes().addTransientAttributeModifiers(Mutation.attributeModifierMultimap(player));
                    if (player.getItemBySlot(EquipmentSlot.HEAD).getMaxDamage() != 0) {
                        player.getItemBySlot(EquipmentSlot.HEAD).hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.HEAD);
                    }
                    if (player.getItemBySlot(EquipmentSlot.CHEST).getMaxDamage() != 0) {
                        player.getItemBySlot(EquipmentSlot.CHEST).hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.CHEST);
                    }
                    if (player.getItemBySlot(EquipmentSlot.LEGS).getMaxDamage() != 0) {
                        player.getItemBySlot(EquipmentSlot.LEGS).hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.LEGS);
                    }
                    if (player.getItemBySlot(EquipmentSlot.FEET).getMaxDamage() == 0) break;
                    player.getItemBySlot(EquipmentSlot.FEET).hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.FEET);
                    break;
                }
                player.getAttributes().removeAttributeModifiers(Mutation.attributeModifierMultimap(player));
            }
        }
    }

    public static void notMagicDamage(LivingIncomingDamageEvent event) {
        Player player;
        ChestInventory chestInventory;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (chestInventory = Handler.getItem(player = (Player)livingEntity)) != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.Mutation_)) continue;
                float DAMAGE = 0.0f;
                if (!player.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                    DAMAGE += 0.25f;
                }
                if (!player.getItemBySlot(EquipmentSlot.CHEST).isEmpty()) {
                    DAMAGE += 0.25f;
                }
                if (!player.getItemBySlot(EquipmentSlot.LEGS).isEmpty()) {
                    DAMAGE += 0.25f;
                }
                if (!player.getItemBySlot(EquipmentSlot.FEET).isEmpty()) {
                    DAMAGE += 0.25f;
                }
                float magic = 0.0f;
                if (event.getSource().is(DamageTypes.MAGIC)) {
                    magic += 1.0f;
                }
                event.setAmount(event.getAmount() * (1.0f + DAMAGE + magic));
                if (Mutation.notEq(player)) {
                    event.setAmount(event.getAmount() * 0.9f);
                }
                if (!event.getSource().is(DamageTypes.IN_FIRE) && !event.getSource().is(DamageTypes.ON_FIRE) && !event.getSource().is(DamageTypes.CAMPFIRE) && !event.getSource().is(DamageTypes.LAVA) && !event.getSource().is(DamageTypes.EXPLOSION) && !event.getSource().is(DamageTypes.PLAYER_EXPLOSION)) break;
                event.setAmount(event.getAmount() * 0.7f);
                break;
            }
        }
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMultimap(Player player) {
        HashMultimap modifiers = HashMultimap.create();
        float armor = 0.0f;
        if (player.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            armor += 4.0f;
        }
        if (player.getItemBySlot(EquipmentSlot.CHEST).isEmpty()) {
            armor += 4.0f;
        }
        if (player.getItemBySlot(EquipmentSlot.LEGS).isEmpty()) {
            armor += 4.0f;
        }
        if (player.getItemBySlot(EquipmentSlot.FEET).isEmpty()) {
            armor += 4.0f;
        }
        modifiers.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.Mutation_.asItem().getDescriptionId())), (double)armor, AttributeModifier.Operation.ADD_VALUE));
        return modifiers;
    }

    public static boolean notEq(Player player) {
        return player.getItemBySlot(EquipmentSlot.HEAD).isEmpty() && player.getItemBySlot(EquipmentSlot.CHEST).isEmpty() && player.getItemBySlot(EquipmentSlot.LEGS).isEmpty() && player.getItemBySlot(EquipmentSlot.FEET).isEmpty();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (stack.get(DataReg.tag) == null) {
            tooltipComponents.add((Component)Component.translatable((String)"chest_item.the_soul.give").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipComponents.add((Component)Component.translatable((String)"chest_item.the_soul.give.1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.mutation.string.9").withStyle(ChatFormatting.GOLD));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.mutation.string.1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))).withStyle(ChatFormatting.ITALIC));
            tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.mutation.string.2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.mutation.string.3").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.mutation.string.4").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.mutation.string.5").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-8371969))).withStyle(ChatFormatting.ITALIC));
            tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.mutation.string.6").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-8371969))));
            tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.mutation.string.7").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-8371969))));
            tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.mutation.string.8").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-8371969))));
        }
    }

    public static void die(LivingDeathEvent event) {
        Player player;
        ChestInventory chestInventory;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && (chestInventory = Handler.getItem(player = (Player)entity)) != null && event.getEntity() instanceof WitherBoss) {
            Mutation.give(chestInventory, player);
        }
    }

    public static void give(ChestInventory chestInventory, Player player) {
        ChestInventory inventory;
        for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
            ItemStack stack = chestInventory.getItem(i);
            if (!stack.is(InitItems.Mutation_)) continue;
            return;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        boolean isCoin = false;
        for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
            if (chestInventory.getItem(i).isEmpty()) {
                list.add(1);
            }
            if (!chestInventory.getItem(i).is(InitItems.DevilCoins_)) continue;
            isCoin = true;
        }
        int o = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int ignored = (Integer)iterator.next();
            ++o;
        }
        if (Mutation.notEq(player) && o >= 8 && isCoin && (inventory = Handler.getItem(player)) != null) {
            ItemStack itemStack10 = inventory.getItem(9);
            ItemStack itemStack11 = inventory.getItem(10);
            ItemStack itemStack12 = inventory.getItem(11);
            ItemStack soul = new ItemStack((ItemLike)InitItems.Mutation_.asItem());
            if (soul.get(DataReg.tag) == null) {
                soul.set(DataReg.tag, (Object)new CompoundTag());
            }
            if (itemStack10.isEmpty()) {
                inventory.setItem(9, soul);
                player.playSound(SoundEvents.ELDER_GUARDIAN_CURSE, 1.0f, 1.0f);
                return;
            }
            if (itemStack11.isEmpty()) {
                inventory.setItem(10, soul);
                player.playSound(SoundEvents.ELDER_GUARDIAN_CURSE, 1.0f, 1.0f);
                return;
            }
            if (itemStack12.isEmpty()) {
                inventory.setItem(11, soul);
                player.playSound(SoundEvents.ELDER_GUARDIAN_CURSE, 1.0f, 1.0f);
                return;
            }
        }
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> muAttribute(Player player, ItemStack stack) {
        return Mutation.attributeModifierMultimap(player);
    }

    @Override
    public ResourceLocation resourceLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"textures/gui/soul/mutation.png");
    }

    @Override
    public int soulColor() {
        return Light.ARGB.color(255, 0, 255, 255);
    }
}

