/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.black.soul;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.AttReg;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.Meat;
import com.ytgld.chest_item.items.black.TheSoul;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.other.DataReg;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class Speed
extends TheSoul {
    public Speed(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ResourceLocation resourceLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"textures/gui/soul/speed.png");
    }

    public static void tick(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        Speed.give(chestInventory, player);
        if (!player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.is(InitItems.Speed_)) {
                    player.getAttributes().addTransientAttributeModifiers(Speed.attributeModifierMultimap());
                    break;
                }
                player.getAttributes().removeAttributeModifiers(Speed.attributeModifierMultimap());
            }
        }
    }

    public static void give(ChestInventory chestInventory, Player player) {
        ChestInventory inventory;
        HashSet<Item> set = new HashSet<Item>();
        for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
            ItemStack stack = chestInventory.getItem(i);
            if (stack.is(InitItems.Speed_)) {
                return;
            }
            if (!(stack.getItem() instanceof Meat)) continue;
            set.add(stack.getItem());
        }
        if (set.size() >= 9 && (inventory = Handler.getItem(player)) != null) {
            ItemStack itemStack10 = inventory.getItem(9);
            ItemStack itemStack11 = inventory.getItem(10);
            ItemStack itemStack12 = inventory.getItem(11);
            ItemStack soul = new ItemStack((ItemLike)InitItems.Speed_.asItem());
            if (soul.get(DataReg.tag) == null) {
                soul.set(DataReg.tag, (Object)new CompoundTag());
            }
            if (itemStack10.isEmpty()) {
                inventory.setItem(9, soul);
                player.playSound(SoundEvents.ELDER_GUARDIAN_CURSE, 1.0f, 1.0f);
                return;
            }
            if (itemStack11.isEmpty()) {
                inventory.setItem(10, soul);
                player.playSound(SoundEvents.ELDER_GUARDIAN_CURSE, 1.0f, 1.0f);
                return;
            }
            if (itemStack12.isEmpty()) {
                inventory.setItem(11, soul);
                player.playSound(SoundEvents.ELDER_GUARDIAN_CURSE, 1.0f, 1.0f);
                return;
            }
        }
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> muAttribute(Player player, ItemStack stack) {
        if (stack.get(DataReg.tag) == null) {
            return HashMultimap.create();
        }
        return Speed.attributeModifierMultimap();
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMultimap() {
        HashMultimap modifiers = HashMultimap.create();
        modifiers.put((Object)Attributes.JUMP_STRENGTH, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.Speed_.asItem().getDescriptionId())), (double)0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        modifiers.put(AttReg.more_speed, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.Speed_.asItem().getDescriptionId())), (double)0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        modifiers.put((Object)Attributes.SAFE_FALL_DISTANCE, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.Speed_.asItem().getDescriptionId())), (double)0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        return modifiers;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (stack.get(DataReg.tag) == null) {
            tooltipComponents.add((Component)Component.translatable((String)"chest_item.the_soul.give").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipComponents.add((Component)Component.translatable((String)"chest_item.the_soul.give.1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.speed.string.2").withStyle(ChatFormatting.GOLD));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.chest_item.speed.string.1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
        }
    }

    @Override
    public boolean canRemove(ItemStack stack) {
        return false;
    }

    @Override
    public int soulColor() {
        return Light.ARGB.color(255, 255, 100, 100);
    }
}

