/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.renderer;

import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TooltipRenderUtil {
    public static void renderTooltipBackground(GuiGraphics guiGraphics, int x, int y, int width, int height, int z, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        int i = x - 3;
        int j = y - 3;
        int k = width + 3 + 3;
        int l = height + 3 + 3;
        TooltipRenderUtil.renderHorizontalLine(guiGraphics, i, j - 1, k, z, backgroundTop);
        TooltipRenderUtil.renderHorizontalLine(guiGraphics, i, j + l, k, z, backgroundBottom);
        TooltipRenderUtil.renderRectangle(guiGraphics, i, j, k, l, z, backgroundTop, backgroundBottom);
        TooltipRenderUtil.renderVerticalLineGradient(guiGraphics, i - 1, j, l, z, backgroundTop, backgroundBottom);
        TooltipRenderUtil.renderVerticalLineGradient(guiGraphics, i + k, j, l, z, backgroundTop, backgroundBottom);
        TooltipRenderUtil.renderFrameGradient(guiGraphics, i, j + 1, k, l, z, borderTop, borderBottom);
    }

    private static void renderFrameGradient(GuiGraphics guiGraphics, int x, int y, int width, int height, int z, int topColor, int bottomColor) {
        TooltipRenderUtil.renderVerticalLineGradient(guiGraphics, x, y, height - 2, z, topColor, bottomColor);
        TooltipRenderUtil.renderVerticalLineGradient(guiGraphics, x + width - 1, y, height - 2, z, topColor, bottomColor);
        TooltipRenderUtil.renderHorizontalLine(guiGraphics, x, y - 1, width, z, topColor);
        TooltipRenderUtil.renderHorizontalLine(guiGraphics, x, y - 1 + height - 1, width, z, bottomColor);
    }

    private static void renderVerticalLineGradient(GuiGraphics guiGraphics, int x, int y, int length, int z, int topColor, int bottomColor) {
        guiGraphics.fillGradient(x, y, x + 1, y + length, z, topColor, bottomColor);
    }

    private static void renderHorizontalLine(GuiGraphics guiGraphics, int x, int y, int length, int z, int color) {
        guiGraphics.fill(x, y, x + length, y + 1, z, color);
    }

    private static void renderRectangle(GuiGraphics guiGraphics, int x, int y, int width, int height, int z, int color, int colorTo) {
        guiGraphics.fillGradient(x, y, x + width, y + height, z, color, colorTo);
    }
}

