/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.tip.an_element.extend;

import com.ytgld.chest_item.other.DataReg;
import com.ytgld.chest_item.tip.an_element.SkillList;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class SkillBase {
    public static final String skillBaseXP = "SkillBaseXP";

    public abstract String baneName();

    public abstract boolean isPercentage();

    public abstract float aneLvlForModify();

    public ResourceLocation baneImage() {
        return ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)this.baneName());
    }

    public static void getElementMap(ItemStack stack, Map<SkillBase, Integer> map, SkillBase name) {
        @Nullable CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        int sa = 0;
        if (compoundTag != null) {
            sa = compoundTag.getInt(name.baneName());
        }
        map.put(name, sa);
    }

    public static boolean isHasElement(ItemStack stack, SkillBase mustHasElement) {
        SkillList skillList;
        Map<SkillBase, Integer> skillBaseIntegerMap;
        Item item = stack.getItem();
        if (item instanceof SkillList && (skillBaseIntegerMap = (skillList = (SkillList)item).element(stack)) != null) {
            for (SkillBase map : skillBaseIntegerMap.keySet()) {
                if (map != mustHasElement) continue;
                return true;
            }
        }
        return false;
    }

    public static int getHasElementLevel(ItemStack stack, SkillBase mustHasElement) {
        @Nullable CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        if (compoundTag != null) {
            return compoundTag.getInt(mustHasElement.baneName());
        }
        return 0;
    }

    public static void addXP(ItemStack stack, SkillBase mustHasElement, int xp, int oneXPForOneLevel, int maxLvl) {
        int xpNumber;
        --maxLvl;
        @Nullable CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        String baneName = mustHasElement.baneName();
        String mixinName = baneName + skillBaseXP;
        if (compoundTag == null) {
            stack.set(DataReg.tag, (Object)new CompoundTag());
        }
        if (compoundTag != null) {
            compoundTag.putInt(mixinName, compoundTag.getInt(mixinName) + xp);
        }
        if (SkillBase.getHasElementLevel(stack, mustHasElement) < maxLvl && compoundTag != null && (xpNumber = compoundTag.getInt(mixinName)) % oneXPForOneLevel == 1) {
            SkillBase.addSkillLevel(stack, mustHasElement);
        }
    }

    private static void addSkillLevel(ItemStack stack, SkillBase base) {
        @Nullable CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        if (compoundTag == null) {
            stack.set(DataReg.tag, (Object)new CompoundTag());
        }
        if (compoundTag != null) {
            String lelSting = base.baneName();
            compoundTag.putInt(lelSting, compoundTag.getInt(lelSting) + 1);
        }
    }
}

