/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.other;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class DrugHeal
extends ItemBase {
    public DrugHeal(Item.Properties properties) {
        super(properties);
    }

    public static void tick(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (!player.level().isClientSide()) {
            ItemStack stack;
            int i;
            for (i = 0; i < chestInventory.getContainerSize(); ++i) {
                stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.Drug_Heal) || player.tickCount % 80 != 0) continue;
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 0, false, false), (Entity)player);
                break;
            }
            for (i = 0; i < chestInventory.getContainerSize(); ++i) {
                stack = chestInventory.getItem(i);
                if (stack.is(InitItems.Drug_Heal)) {
                    player.getAttributes().addTransientAttributeModifiers(DrugHeal.attributeModifierMultimap());
                    break;
                }
                player.getAttributes().removeAttributeModifiers(DrugHeal.attributeModifierMultimap());
            }
        }
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> muAttribute(Player player) {
        return DrugHeal.attributeModifierMultimap();
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMultimap() {
        HashMultimap modifiers = HashMultimap.create();
        modifiers.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.Drug_Heal.asItem().getDescriptionId())), 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return modifiers;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipAdder, flag);
        tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.drug_heal.string.0").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.ITALIC));
        tooltipAdder.add((Component)Component.literal((String)""));
        tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.drug_heal.string.1").withStyle(ChatFormatting.GOLD));
    }

    @Override
    public int color(ItemStack stack) {
        return Light.ARGB.color(255, 0, 255, 20);
    }
}

