/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.mixin.cilent;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.items.Meat;
import com.ytgld.chest_item.items.Terror;
import com.ytgld.chest_item.renderer.IGUI;
import com.ytgld.chest_item.renderer.MGuiGraphics;
import com.ytgld.chest_item.renderer.TooltipRenderUtil;
import com.ytgld.chest_item.renderer.i.IAbstractContainerScreen;
import com.ytgld.chest_item.renderer.i.IGuiGraphics;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import org.joml.Matrix4f;
import org.joml.Vector2ic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public abstract class GuiGraphicsMixin
implements IGuiGraphics,
IGUI {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private boolean managed;
    @Shadow
    private ItemStack tooltipStack;
    @Shadow
    @Final
    private GuiSpriteManager sprites;
    @Shadow
    @Final
    private PoseStack pose;

    @Shadow
    public abstract int guiWidth();

    @Shadow
    public abstract int guiHeight();

    @Shadow
    public abstract void flush();

    @Shadow
    public abstract PoseStack pose();

    @Override
    public GuiSpriteManager cI1_21_1$sprites() {
        return this.sprites;
    }

    @Override
    public void chest_item$addW(ItemStack stack) {
        GuiGraphics guiGraphics = (GuiGraphics)this;
        Item item = stack.getItem();
        if (item instanceof Terror) {
            IAbstractContainerScreen iAbstractContainerScreen;
            List<Vec2> xy;
            Terror terror = (Terror)item;
            guiGraphics.pose().pushPose();
            Screen screen = this.minecraft.screen;
            if (screen instanceof IAbstractContainerScreen && (xy = (iAbstractContainerScreen = (IAbstractContainerScreen)screen).chest_item$xy()) != null) {
                for (int i = 1; i < xy.size(); ++i) {
                    Vec2 prevPos = xy.get(i - 1);
                    Vec2 currPos = xy.get(i);
                    if (prevPos.x == 0.0f || prevPos.y == 0.0f || currPos.x == 0.0f || currPos.y == 0.0f) continue;
                    float alpha = (float)i / (float)xy.size();
                    Vec2 adjustedPrevPos = new Vec2(prevPos.x, prevPos.y);
                    Vec2 adjustedCurrPos = new Vec2(currPos.x, currPos.y);
                    this.pose.pushPose();
                    this.pose.translate(prevPos.x, prevPos.y, 0.0f);
                    this.pose.scale(alpha * 1.55f, alpha * 1.55f, alpha * 1.55f);
                    this.pose.translate(-prevPos.x, -prevPos.y, 0.0f);
                    int color = terror.color(stack);
                    int rs = color >> 16 & 0xFF;
                    int gs = color >> 8 & 0xFF;
                    int bs = color & 0xFF;
                    float r = (float)rs / 255.0f;
                    float g = (float)gs / 255.0f;
                    float b = (float)bs / 255.0f;
                    MGuiGraphics.blit(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"textures/gui/tooltip/fire.png"), adjustedCurrPos.x - 12.0f, adjustedCurrPos.y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, r, g, b * alpha, alpha);
                    MGuiGraphics.blit(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"textures/gui/tooltip/fire.png"), adjustedPrevPos.x - 12.0f, adjustedPrevPos.y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, r, g, b * alpha, alpha);
                    this.pose.popPose();
                }
            }
            guiGraphics.pose().popPose();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"renderTooltipInternal(Lnet/minecraft/client/gui/Font;Ljava/util/List;IILnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;)V"})
    public void moonstone$ClientTooltipPositioner(Font p_282675_, List<ClientTooltipComponent> p_282615_, int x, int y, ClientTooltipPositioner p_282442_, CallbackInfo ci) {
        if (this.tooltipStack.getItem() instanceof ItemBase) {
            this.ci$drawManaged(() -> {
                RenderTooltipEvent.Pre preEvent = ClientHooks.onRenderTooltipPre((ItemStack)this.tooltipStack, (GuiGraphics)((GuiGraphics)this), (int)x, (int)y, (int)this.guiWidth(), (int)this.guiHeight(), (List)p_282615_, (Font)p_282675_, (ClientTooltipPositioner)p_282442_);
                int i = 0;
                int j = p_282615_.size() == 1 ? -2 : 0;
                for (ClientTooltipComponent clienttooltipcomponent : p_282615_) {
                    int k = clienttooltipcomponent.getWidth(preEvent.getFont());
                    if (k > i) {
                        i = k;
                    }
                    j += clienttooltipcomponent.getHeight();
                }
                int i2 = i;
                int j2 = j;
                Vector2ic vector2ic = p_282442_.positionTooltip(this.guiWidth(), this.guiHeight(), preEvent.getX(), preEvent.getY(), i2, j2);
                int l = vector2ic.x();
                int i1 = vector2ic.y();
                this.pose.pushPose();
                RenderTooltipEvent.Color colorEvent = ClientHooks.onRenderTooltipColor((ItemStack)this.tooltipStack, (GuiGraphics)((GuiGraphics)this), (int)l, (int)i1, (Font)preEvent.getFont(), (List)p_282615_);
                TooltipRenderUtil.renderTooltipBackground((GuiGraphics)this, l, i1, i, j, 400, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd(), Light.ARGB.color(255, 218, 165, 32), Light.ARGB.color(255, 219, 112, 147));
                this.pose.popPose();
                if (this.tooltipStack.getItem() instanceof Meat) {
                    this.pose.pushPose();
                    this.si1_21_4$renderTooltipBackground((GuiGraphics)this, l, i1, i, j, 400);
                    this.pose.popPose();
                }
            });
        }
    }

    @Unique
    public void ci$drawManaged(Runnable pRunnable) {
        this.flush();
        this.managed = true;
        pRunnable.run();
        this.managed = false;
        this.flush();
    }

    @Unique
    void cI1_21_1$innerBlit(ResourceLocation atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Matrix4f matrix4f = this.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, (float)x1, (float)y1, (float)blitOffset).setUv(minU, minV);
        bufferbuilder.addVertex(matrix4f, (float)x1, (float)y2, (float)blitOffset).setUv(minU, maxV);
        bufferbuilder.addVertex(matrix4f, (float)x2, (float)y2, (float)blitOffset).setUv(maxU, maxV);
        bufferbuilder.addVertex(matrix4f, (float)x2, (float)y1, (float)blitOffset).setUv(maxU, minV);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    @Unique
    public void si1_21_4$renderTooltipBackground(GuiGraphics guiGraphics, int x, int y, int width, int height, int z) {
        int topLeftX = x - 3 - 9 + 2;
        int topLeftY = y - 3 - 9;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, -2.0f, 0.0f);
        guiGraphics.blitSprite(ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"tooltip/tool_0_0"), 48, 48, 0, 0, topLeftX, topLeftY, 48, 48);
        guiGraphics.pose().popPose();
        int middleX = x + (width - 48) / 2;
        int middleY = y - 3 - 6;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, -7.0f, 0.0f);
        guiGraphics.blitSprite(ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"tooltip/tool_middle_0"), 48, 48, 0, 0, middleX, middleY, 48, 48);
        guiGraphics.pose().popPose();
        int topRightX = x + width + 3 - 48 + 6;
        int topRightY = y - 3 - 9;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, -2.0f, 0.0f);
        guiGraphics.blitSprite(ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"tooltip/tool_0_1"), 48, 48, 0, 0, topRightX, topRightY, 48, 48);
        guiGraphics.pose().popPose();
        int bottomLeftX = x - 3 - 9 + 2;
        int bottomLeftY = y + height + 3 - 48 + 4;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 4.0f, 0.0f);
        guiGraphics.blitSprite(ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"tooltip/tool_1_0"), 48, 48, 0, 0, bottomLeftX, bottomLeftY, 48, 48);
        guiGraphics.pose().popPose();
        int bottomRightX = x + width + 3 - 48 + 6;
        int bottomRightY = y + height + 3 - 48 + 4;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 4.0f, 0.0f);
        guiGraphics.blitSprite(ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"tooltip/tool_1_1"), 48, 48, 0, 0, bottomRightX, bottomRightY, 48, 48);
        guiGraphics.pose().popPose();
    }

    @Unique
    private void chest_item$renderTooltipBackground(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int i = x - 3 - 9;
        int j = y - 3 - 9;
        int k = width + 3 + 3 + 18;
        int l = height + 3 + 3 + 18;
        guiGraphics.blitSprite(ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"tooltip/frame"), i, j, k, l);
    }
}

