/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.HandlerClient;
import com.ytgld.chest_item.entity.EndComing;
import com.ytgld.chest_item.entity.state.EndComingRenderState;
import com.ytgld.chest_item.renderer.MRender;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EndComingRender
extends EntityRenderer<EndComing, EndComingRenderState> {
    public EndComingRender(EntityRendererProvider.Context p_173917_) {
        super(p_173917_);
    }

    public boolean shouldRender(EndComing livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    @NotNull
    public EndComingRenderState createRenderState() {
        return new EndComingRenderState();
    }

    public void submit(EndComingRenderState renderState, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        HandlerClient.showOutline = true;
        EndComing entity = renderState.entity;
        double x = Mth.lerp((double)renderState.partialTick, (double)entity.xOld, (double)entity.getX());
        double y = Mth.lerp((double)renderState.partialTick, (double)entity.yOld, (double)entity.getY());
        double z = Mth.lerp((double)renderState.partialTick, (double)entity.zOld, (double)entity.getZ());
        poseStack.pushPose();
        poseStack.translate(entity.getX() - x, entity.getY() - y, entity.getZ() - z);
        collector.submitCustomGeometry(poseStack, MRender.red(true), (pose, bufferSource) -> this.setT(pose, entity, bufferSource));
        collector.submitCustomGeometry(poseStack, MRender.red(false), (pose, bufferSource) -> this.setT(pose, entity, bufferSource));
        collector.submitCustomGeometry(poseStack, MRender.red(true), (pose, bufferSource) -> this.renderSphere1(pose, bufferSource, 0, 0.35f));
        collector.submitCustomGeometry(poseStack, MRender.red(false), (pose, bufferSource) -> this.renderSphere1(pose, bufferSource, 100, 0.35f));
        poseStack.popPose();
    }

    private void setT(PoseStack.Pose matrices, EndComing entity, VertexConsumer vertexConsumers) {
        for (int i = 1; i < entity.getTrailPositions().size(); ++i) {
            Vec3 prevPos = entity.getTrailPositions().get(i - 1);
            Vec3 currPos = entity.getTrailPositions().get(i);
            Vec3 adjustedPrevPos = new Vec3(prevPos.x - entity.getX(), prevPos.y - entity.getY(), prevPos.z - entity.getZ());
            Vec3 adjustedCurrPos = new Vec3(currPos.x - entity.getX(), currPos.y - entity.getY(), currPos.z - entity.getZ());
            float alpha = (float)i / (float)entity.getTrailPositions().size();
            Handler.renderBlood(matrices, vertexConsumers, adjustedPrevPos, adjustedCurrPos, alpha, alpha / 3.0f);
            Handler.renderBlood(matrices, vertexConsumers, adjustedPrevPos, adjustedCurrPos, alpha, alpha / 3.0f);
        }
    }

    public void renderSphere1(@NotNull PoseStack.Pose matrices, @NotNull VertexConsumer vertexConsumer, int light, float s) {
        int stacks = 10;
        int slices = 10;
        for (int i = 0; i < stacks; ++i) {
            float phi0 = (float)Math.PI * ((float)(i + 0) / (float)stacks);
            float phi1 = (float)Math.PI * ((float)(i + 1) / (float)stacks);
            for (int j = 0; j < slices; ++j) {
                float theta0 = (float)Math.PI * 2 * ((float)(j + 0) / (float)slices);
                float theta1 = (float)Math.PI * 2 * ((float)(j + 1) / (float)slices);
                float x0 = s * (float)Math.sin(phi0) * (float)Math.cos(theta0);
                float y0 = s * (float)Math.cos(phi0);
                float z0 = s * (float)Math.sin(phi0) * (float)Math.sin(theta0);
                float x1 = s * (float)Math.sin(phi0) * (float)Math.cos(theta1);
                float y1 = s * (float)Math.cos(phi0);
                float z1 = s * (float)Math.sin(phi0) * (float)Math.sin(theta1);
                float x2 = s * (float)Math.sin(phi1) * (float)Math.cos(theta1);
                float y2 = s * (float)Math.cos(phi1);
                float z2 = s * (float)Math.sin(phi1) * (float)Math.sin(theta1);
                float x3 = s * (float)Math.sin(phi1) * (float)Math.cos(theta0);
                float y3 = s * (float)Math.cos(phi1);
                float z3 = s * (float)Math.sin(phi1) * (float)Math.sin(theta0);
                vertexConsumer.addVertex(matrices, x0, y0, z0).setColor(1.0f, 1.0f, 1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(matrices, 1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrices, x1, y1, z1).setColor(1.0f, 1.0f, 1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(matrices, 1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrices, x2, y2, z2).setColor(1.0f, 1.0f, 1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(matrices, 1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrices, x3, y3, z3).setColor(1.0f, 1.0f, 1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(matrices, 1.0f, 0.0f, 0.0f);
            }
        }
    }

    public void extractRenderState(EndComing entity, EndComingRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)reusedState, partialTick);
        reusedState.entity = entity;
        reusedState.partialTick = partialTick;
    }
}

