/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.meet;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.AttReg;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.items.Meat;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.other.DataReg;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.Nullable;

public class GodApple
extends ItemBase
implements Meat {
    public static final int TIME = 200;
    public static final String bloodTime = "bloodTime";
    public static final String bloodDamage = "bloodDamage";

    public GodApple(Item.Properties properties) {
        super(properties);
    }

    public static void event(LivingDamageEvent.Pre event) {
        ChestInventory chestInventory;
        Player player;
        LivingEntity livingEntity;
        if (!event.getSource().is(DamageTypes.GENERIC_KILL) && (livingEntity = event.getEntity()) instanceof Player && !(player = (Player)livingEntity).level().isClientSide() && (chestInventory = Handler.getItem(player)) != null) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                float s;
                CompoundTag compoundTag;
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is((Item)InitItems.God_Apple.get()) || (compoundTag = (CompoundTag)stack.get(DataReg.tag)) == null || !((s = event.getNewDamage() - 5.0f) > 5.0f)) continue;
                compoundTag.putFloat(bloodDamage, compoundTag.getFloatOr(bloodDamage, 0.0f) + s);
                compoundTag.putInt(bloodTime, 200);
                event.setNewDamage(5.0f);
                break;
            }
        }
    }

    public static void event(ItemStackTickEvent event) {
        Player player = event.player;
        ChestInventory chestInventory = event.chestInventory;
        if (!player.level().isClientSide() && chestInventory != null) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is((Item)InitItems.God_Apple.get())) continue;
                CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
                if (compoundTag != null) {
                    if (compoundTag.getIntOr(bloodTime, 0) <= 0) {
                        compoundTag.putFloat(bloodDamage, 0.0f);
                    }
                    if (compoundTag.getIntOr(bloodDamage, 0) <= 0) {
                        compoundTag.putFloat(bloodTime, 0.0f);
                    }
                    if (player.isDeadOrDying()) {
                        compoundTag.putFloat(bloodDamage, 0.0f);
                        compoundTag.putFloat(bloodTime, 0.0f);
                    }
                    if (player.level().isClientSide() || player.tickCount % 20 != 1 || compoundTag.getIntOr(bloodTime, 0) <= 0 || !(compoundTag.getFloatOr(bloodDamage, 0.0f) > 0.0f)) break;
                    compoundTag.putInt(bloodTime, compoundTag.getIntOr(bloodTime, 0) - 20);
                    float dmg = compoundTag.getFloatOr(bloodDamage, 0.0f) / 10.0f;
                    compoundTag.putFloat(bloodDamage, compoundTag.getFloatOr(bloodDamage, 0.0f) - dmg);
                    player.hurt(player.damageSources().genericKill(), dmg);
                    break;
                }
                stack.set(DataReg.tag, (Object)new CompoundTag());
            }
        }
    }

    public static void event2(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (!player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.is(InitItems.God_Apple)) {
                    player.getAttributes().addTransientAttributeModifiers(GodApple.attributeModifierMultimap());
                    break;
                }
                player.getAttributes().removeAttributeModifiers(GodApple.attributeModifierMultimap());
            }
        }
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> muAttribute(Player player, ItemStack stack) {
        return GodApple.attributeModifierMultimap();
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMultimap() {
        HashMultimap modifiers = HashMultimap.create();
        modifiers.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.God_Apple.asItem().getDescriptionId())), -0.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        modifiers.put(AttReg.heal, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.God_Apple.asItem().getDescriptionId())), -0.4, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        return modifiers;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.god_apple.string.0").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.ITALIC));
        tooltipAdder.accept((Component)Component.literal((String)""));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.god_apple.string.3").withStyle(ChatFormatting.GOLD));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.god_apple.string.4").withStyle(ChatFormatting.GOLD));
    }

    @Override
    public int color(ItemStack stack) {
        return Light.ARGB.color(255, 255, 135, 105);
    }
}

