/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.other.ChestItemMenu;
import com.ytgld.chest_item.other.IPlayer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class Handler {
    public static void openItemChest(Player player) {
        if (player instanceof IPlayer) {
            IPlayer iPlayer = (IPlayer)player;
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.CHEST_OPEN, SoundSource.AMBIENT, 1.0f, 1.0f);
            player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, p_53126_) -> new ChestItemMenu(i, inventory, (Container)iPlayer.chest_item$chestInventory().get(), 2), (Component)Component.translatable((String)"container.chest_item.chest")));
        }
    }

    @Nullable
    public static ChestInventory getItem(Player player) {
        if (player instanceof IPlayer) {
            IPlayer iPlayer = (IPlayer)player;
            return iPlayer.chest_item$chestInventory().get();
        }
        return null;
    }

    public static void renderBlood(PoseStack.Pose poseStack, VertexConsumer vertexConsumer, Vec3 start, Vec3 end, float a, float r) {
        int segmentCount = 16;
        for (int i = 0; i < segmentCount; ++i) {
            double angle1 = Math.PI * 2 * (double)i / (double)segmentCount;
            double angle2 = Math.PI * 2 * (double)(i + 1) / (double)segmentCount;
            double x1 = Math.cos(angle1) * (double)r;
            double z1 = Math.sin(angle1) * (double)r;
            double x2 = Math.cos(angle2) * (double)r;
            double z2 = Math.sin(angle2) * (double)r;
            Vec3 up1 = start.add(x1, 0.0, z1);
            Vec3 up2 = start.add(x2, 0.0, z2);
            Vec3 down1 = end.add(x1, 0.0, z1);
            Vec3 down2 = end.add(x2, 0.0, z2);
            Handler.addSquare(vertexConsumer, poseStack, up1, up2, down1, down2, a);
        }
    }

    private static void addSquare(VertexConsumer vertexConsumer, PoseStack.Pose poseStack, Vec3 up1, Vec3 up2, Vec3 down1, Vec3 down2, float alpha) {
        vertexConsumer.addVertex(poseStack, (float)up1.x, (float)up1.y, (float)up1.z).setColor(100, 100, 255, (int)(alpha * 255.0f)).setUv2(240, 240).setNormal(poseStack, 0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(poseStack, (float)down1.x, (float)down1.y, (float)down1.z).setColor(100, 100, 255, (int)(alpha * 255.0f)).setUv2(240, 240).setNormal(poseStack, 0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(poseStack, (float)down2.x, (float)down2.y, (float)down2.z).setColor(100, 100, 255, (int)(alpha * 255.0f)).setUv2(240, 240).setNormal(poseStack, 0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(poseStack, (float)up2.x, (float)up2.y, (float)up2.z).setColor(100, 100, 255, (int)(alpha * 255.0f)).setUv2(240, 240).setNormal(poseStack, 0.0f, 0.0f, 1.0f);
    }
}

