/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.black.soul;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.TheImprintOfTheSoul;
import com.ytgld.chest_item.other.ChestInventory;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class TheOrderOfTheUndead
extends TheImprintOfTheSoul {
    public TheOrderOfTheUndead(Item.Properties properties) {
        super(properties);
    }

    public static void notMagicDamage(LivingIncomingDamageEvent event) {
        Player player;
        ChestInventory chestInventory;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && (chestInventory = Handler.getItem(player = (Player)entity)) != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.TheOrderOfTheUndead_) || event.getSource().is(DamageTypes.MAGIC)) continue;
                event.setAmount(event.getAmount() * 1.3f);
                break;
            }
        }
    }

    public static void immMagic(Player player, DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        ChestInventory chestInventory = Handler.getItem(player);
        if (chestInventory != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.TheOrderOfTheUndead_) || !damageSource.is(DamageTypes.MAGIC)) continue;
                cir.setReturnValue((Object)true);
                break;
            }
        }
    }

    public static void canHasEffect(Player player, MobEffectInstance effectInstance, CallbackInfoReturnable<Boolean> cir) {
        ChestInventory chestInventory = Handler.getItem(player);
        if (chestInventory != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.TheOrderOfTheUndead_) || ((MobEffect)effectInstance.getEffect().value()).isBeneficial()) continue;
                cir.setReturnValue((Object)false);
                break;
            }
        }
    }

    public static void LivingChangeTargetEvent(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getNewAboutToBeSetTarget();
        if (livingEntity instanceof Player) {
            ChestInventory chestInventory;
            Player player = (Player)livingEntity;
            if (event.getEntity().getType().is(EntityTypeTags.UNDEAD) && (chestInventory = Handler.getItem(player)) != null && !player.level().isClientSide()) {
                for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                    ItemStack stack = chestInventory.getItem(i);
                    if (!stack.is(InitItems.TheOrderOfTheUndead_)) continue;
                    if (player.getLastHurtMob() != null && player.getLastHurtMob().is((Entity)event.getEntity())) {
                        return;
                    }
                    event.setCanceled(true);
                    break;
                }
            }
        }
    }

    public static void healAndMagicDamage(Player player, CallbackInfoReturnable<Boolean> cir) {
        ChestInventory chestInventory = Handler.getItem(player);
        if (chestInventory != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.TheOrderOfTheUndead_)) continue;
                cir.setReturnValue((Object)false);
                break;
            }
        }
    }

    public static void hunger(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (chestInventory != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.TheOrderOfTheUndead_)) continue;
                if (player.getRemainingFireTicks() > 0) {
                    player.setRemainingFireTicks(100);
                }
                if (player.tickCount % 400 != 1) break;
                player.getFoodData().eat(-1, -0.5f);
                break;
            }
        }
    }

    public static void attrib(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (player != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.is(InitItems.TheOrderOfTheUndead_)) {
                    player.getAttributes().addTransientAttributeModifiers(TheOrderOfTheUndead.attributeModifierMultimap(player));
                    break;
                }
                player.getAttributes().removeAttributeModifiers(TheOrderOfTheUndead.attributeModifierMultimap(player));
            }
        }
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMultimap(Player player) {
        HashMultimap modifiers = HashMultimap.create();
        float a = 20 - player.getFoodData().getFoodLevel();
        float speed = 0.0f;
        if (a > 5.0f) {
            speed = -0.2f;
        }
        modifiers.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.TheOrderOfTheUndead_.asItem().getDescriptionId())), (double)speed, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return modifiers;
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> muAttribute(Player player, ItemStack stack) {
        return TheOrderOfTheUndead.attributeModifierMultimap(player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.the_order_of_the_undead.string.1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))).withStyle(ChatFormatting.ITALIC));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.the_order_of_the_undead.string.2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.the_order_of_the_undead.string.3").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.the_order_of_the_undead.string.4").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.the_order_of_the_undead.string.9").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
        tooltipAdder.accept((Component)Component.literal((String)""));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.the_order_of_the_undead.string.5").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-8371969))).withStyle(ChatFormatting.ITALIC));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.the_order_of_the_undead.string.6").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-8371969))));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.the_order_of_the_undead.string.7").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-8371969))));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.the_order_of_the_undead.string.8").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-8371969))));
    }

    @Override
    public ResourceLocation resourceLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"textures/gui/soul/the_order_of_the_undead.png");
    }

    @Override
    public int soulColor() {
        return -9807155;
    }
}

