/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.other;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.AttReg;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LoneWolf
extends ItemBase {
    public LoneWolf(Item.Properties properties) {
        super(properties);
    }

    public static void ItemStackTickEvent(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (player != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.is(InitItems.LoneWolf_)) {
                    player.getAttributes().addTransientAttributeModifiers(LoneWolf.attributeModifierMultimap(player));
                    break;
                }
                player.getAttributes().removeAttributeModifiers(LoneWolf.attributeModifierMultimap(player));
            }
        }
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMultimap(Player player) {
        HashMultimap modifiers = HashMultimap.create();
        float apply = 0.0f;
        if (LoneWolf.isNOt((LivingEntity)player)) {
            apply = 0.15f;
        }
        modifiers.put(AttReg.more_speed, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.LoneWolf_.asItem().getDescriptionId())), (double)apply, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return modifiers;
    }

    public static boolean isNOt(LivingEntity me) {
        Vec3 playerPos = me.position();
        int range = 4;
        ArrayList<Integer> integers = new ArrayList<Integer>();
        List entities = me.level().getEntitiesOfClass(LivingEntity.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
        for (LivingEntity living : entities) {
            if (living.is((Entity)me)) continue;
            integers.add(1);
        }
        return integers.isEmpty();
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> muAttribute(Player player, ItemStack stack) {
        return LoneWolf.attributeModifierMultimap(player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.lone_wolf.string.1").withStyle(ChatFormatting.GOLD));
    }

    @Override
    public int color(ItemStack stack) {
        return Light.ARGB.color(255, 255, 100, 50);
    }
}

