/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.other;

import com.ytgld.chest_item.items.ItemBase;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ChestInventory
extends SimpleContainer {
    public ChestInventory(Player player) {
        super(24);
    }

    public void fromSlots(ValueInput.TypedInputList<ItemStackWithSlot> input) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
        for (ItemStackWithSlot itemstackwithslot : input) {
            if (!itemstackwithslot.isValidInContainer(this.getContainerSize())) continue;
            this.setItem(itemstackwithslot.slot(), itemstackwithslot.stack());
        }
    }

    public void drop(Player player) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemstack = this.getItem(i);
            if (itemstack.isEmpty() || itemstack.getItem() instanceof ItemBase) continue;
            int count = itemstack.getCount();
            player.drop(itemstack.copy(), false);
            itemstack.shrink(count);
        }
    }

    public void stopOpen(ContainerUser containerUser) {
        LivingEntity living = containerUser.getLivingEntity();
        if (living instanceof Player) {
            Player player = (Player)living;
            this.drop(player);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.CHEST_CLOSE, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    public void storeAsSlots(ValueOutput.TypedOutputList<ItemStackWithSlot> output) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemstack = this.getItem(i);
            if (itemstack.isEmpty()) continue;
            output.add((Object)new ItemStackWithSlot(i, itemstack));
        }
    }
}

