/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.black.soul.chaos;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.effect.Effects;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.AttReg;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.black.soul.chaos.TheChaos;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.other.DataReg;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class ChaosSeven
extends TheChaos {
    public static final String uDead = "ChaosSeven";

    public ChaosSeven(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean isChaos() {
        return true;
    }

    public static void exp(LivingExperienceDropEvent event) {
        Player player;
        ChestInventory chestInventory;
        Player player2 = event.getAttackingPlayer();
        if (player2 instanceof Player && (chestInventory = Handler.getItem(player = player2)) != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.ChaosSeven_)) continue;
                event.setDroppedExperience((int)((float)event.getDroppedExperience() * 1.5f));
                break;
            }
        }
    }

    public static void canBeAffected(MobEffectInstance effectInstance, CallbackInfoReturnable<Boolean> cir, Player player) {
        ChestInventory chestInventory = Handler.getItem(player);
        if (chestInventory != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.ChaosSeven_) || !effectInstance.is(MobEffects.BLINDNESS) && !effectInstance.is(MobEffects.DARKNESS)) continue;
                cir.setReturnValue((Object)false);
                break;
            }
        }
    }

    public static void tick(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (!player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.is(InitItems.ChaosSeven_)) {
                    if (player.tickCount < 20) {
                        player.addEffect(new MobEffectInstance(Effects.invulnerable, 200, 0, false, false, false));
                    }
                    CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
                    if (compoundTag == null) {
                        stack.set(DataReg.tag, (Object)new CompoundTag());
                    }
                    float lv = player.getHealth() / player.getMaxHealth();
                    int now = (int)(100.0f - (lv *= 100.0f));
                    if (compoundTag != null) {
                        compoundTag.putInt(uDead, now);
                        if (compoundTag.getInt(uDead) <= 0) {
                            compoundTag.putInt(uDead, 0);
                        }
                    }
                    player.getAttributes().addTransientAttributeModifiers(ChaosSeven.attributeModifierMultimap(stack));
                    break;
                }
                player.getAttributes().removeAttributeModifiers(ChaosSeven.attributeModifierMultimap(stack));
            }
        }
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMultimap(ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        modifiers.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ResourceLocation.parse((String)("aaachest_item" + InitItems.ChaosSeven_.asItem().getDescriptionId())), 5.0, AttributeModifier.Operation.ADD_VALUE));
        modifiers.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.parse((String)("aaachest_item" + InitItems.ChaosSeven_.asItem().getDescriptionId())), 5.0, AttributeModifier.Operation.ADD_VALUE));
        modifiers.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.parse((String)("aaachest_item" + InitItems.ChaosSeven_.asItem().getDescriptionId())), 5.0, AttributeModifier.Operation.ADD_VALUE));
        modifiers.put(AttReg.heal, (Object)new AttributeModifier(ResourceLocation.parse((String)("aaachest_item" + InitItems.ChaosSeven_.asItem().getDescriptionId())), 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        modifiers.put(AttReg.looting, (Object)new AttributeModifier(ResourceLocation.parse((String)("aaachest_item" + InitItems.ChaosSeven_.asItem().getDescriptionId())), 1.0, AttributeModifier.Operation.ADD_VALUE));
        modifiers.put(AttReg.fortune, (Object)new AttributeModifier(ResourceLocation.parse((String)("aaachest_item" + InitItems.ChaosSeven_.asItem().getDescriptionId())), 1.0, AttributeModifier.Operation.ADD_VALUE));
        CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        if (compoundTag != null) {
            int lvl = compoundTag.getInt(uDead);
            float heal = 0.0025525526f * (float)lvl;
            float speed = 0.0024024025f * (float)lvl;
            float damage = 0.0022522523f * (float)lvl;
            float attSpeed = 0.0015015015f * (float)lvl;
            float armor = 0.0010510511f * (float)lvl;
            modifiers.put(AttReg.heal, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.ChaosSeven_.asItem().getDescriptionId())), (double)heal, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.ChaosSeven_.asItem().getDescriptionId())), (double)speed, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.ChaosSeven_.asItem().getDescriptionId())), (double)damage, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.ChaosSeven_.asItem().getDescriptionId())), (double)attSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.ChaosSeven_.asItem().getDescriptionId())), (double)armor, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        return modifiers;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipAdder, flag);
        if (stack.get(DataReg.tag) == null) {
            tooltipAdder.add((Component)Component.translatable((String)"chest_item.the_soul.give").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipAdder.add((Component)Component.translatable((String)"chest_item.the_soul.give.1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipAdder.add((Component)Component.literal((String)""));
            if (flag.hasShiftDown()) {
                tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.1").withStyle(ChatFormatting.GRAY));
                tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.2").withStyle(ChatFormatting.GRAY));
                tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.3").withStyle(ChatFormatting.GRAY));
                tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.4").withStyle(ChatFormatting.GRAY));
                tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.5").withStyle(ChatFormatting.GRAY));
                tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.6").withStyle(ChatFormatting.GRAY));
                tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.7").withStyle(ChatFormatting.GRAY));
                tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.8").withStyle(ChatFormatting.GRAY));
                tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.9").withStyle(ChatFormatting.GRAY));
                tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.10").withStyle(ChatFormatting.GRAY));
            } else {
                tooltipAdder.add((Component)Component.translatable((String)"options.key.hold").append((Component)Component.translatable((String)"key.keyboard.left.shift")).withStyle(ChatFormatting.GOLD));
            }
            tooltipAdder.add((Component)Component.literal((String)""));
            tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.11").withStyle(ChatFormatting.GOLD));
        } else {
            tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.12").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.13").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.14").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.15").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.16").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.17").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.chaos_seven.string.18").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
        }
    }

    public static void die(LivingDeathEvent event) {
        Player player;
        ChestInventory chestInventory;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && (chestInventory = Handler.getItem(player = (Player)entity)) != null && event.getEntity() instanceof EnderDragon) {
            ChaosSeven.give(chestInventory, player);
        }
    }

    public static void give(ChestInventory chestInventory, Player player) {
        ChestInventory inventory;
        Object mobEffectInstance2;
        for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
            ItemStack stack = chestInventory.getItem(i);
            if (!stack.is(InitItems.ChaosSeven_)) continue;
            return;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        Collection collection = player.getActiveEffects();
        for (Object mobEffectInstance2 : collection) {
            if (!((MobEffect)mobEffectInstance2.getEffect().value()).isBeneficial() && ((MobEffect)mobEffectInstance2.getEffect().value()).isBeneficial()) continue;
            list.add(1);
        }
        int o = 0;
        mobEffectInstance2 = list.iterator();
        while (mobEffectInstance2.hasNext()) {
            int ignored = (Integer)mobEffectInstance2.next();
            ++o;
        }
        if (o >= 7 && (inventory = Handler.getItem(player)) != null) {
            ItemStack itemStack10 = inventory.getItem(9);
            ItemStack itemStack11 = inventory.getItem(10);
            ItemStack itemStack12 = inventory.getItem(11);
            ItemStack soul = new ItemStack((ItemLike)InitItems.ChaosSeven_.asItem());
            if (soul.get(DataReg.tag) == null) {
                soul.set(DataReg.tag, (Object)new CompoundTag());
            }
            if (itemStack10.isEmpty()) {
                player.playSound(SoundEvents.ELDER_GUARDIAN_CURSE, 1.0f, 1.0f);
                inventory.setItem(9, soul);
                return;
            }
            if (itemStack11.isEmpty()) {
                player.playSound(SoundEvents.ELDER_GUARDIAN_CURSE, 1.0f, 1.0f);
                inventory.setItem(10, soul);
                return;
            }
            if (itemStack12.isEmpty()) {
                player.playSound(SoundEvents.ELDER_GUARDIAN_CURSE, 1.0f, 1.0f);
                inventory.setItem(11, soul);
                return;
            }
        }
    }

    @Override
    public boolean canRemove(ItemStack stack) {
        return false;
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> muAttribute(Player player, ItemStack stack) {
        if (stack.get(DataReg.tag) == null) {
            return HashMultimap.create();
        }
        return ChaosSeven.attributeModifierMultimap(stack);
    }

    @Override
    public ResourceLocation resourceLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"textures/gui/soul/chaos_seven.png");
    }

    @Override
    public int soulColor() {
        return Light.ARGB.color(255, 255, 75, 255);
    }
}

