/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.other;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ChestInventory
extends SimpleContainer {
    public ChestInventory(Player player) {
        super(24);
    }

    public void fromTag(ListTag tag, HolderLookup.Provider levelRegistry) {
        int k;
        for (k = 0; k < this.getContainerSize(); ++k) {
            this.setItem(k, ItemStack.EMPTY);
        }
        for (k = 0; k < tag.size(); ++k) {
            CompoundTag compoundtag = tag.getCompound(k);
            int j = compoundtag.getByte("Slot") & 0xFF;
            if (j >= this.getContainerSize()) continue;
            this.setItem(j, ItemStack.parse((HolderLookup.Provider)levelRegistry, (Tag)compoundtag).orElse(ItemStack.EMPTY));
        }
    }

    @NotNull
    public ListTag createTag(HolderLookup.Provider levelRegistry) {
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemstack = this.getItem(i);
            if (itemstack.isEmpty()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.putByte("Slot", (byte)i);
            listtag.add((Object)itemstack.save(levelRegistry, (Tag)compoundtag));
        }
        return listtag;
    }

    public void stopOpen(Player player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.CHEST_CLOSE, SoundSource.AMBIENT, 1.0f, 1.0f);
        super.stopOpen(player);
    }
}

